/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nexus;

import java.io.Serializable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MavenArtifact
implements Serializable {
    private static final long serialVersionUID = -9112154330099159722L;
    private String groupId;
    private String artifactId;
    private String version;
    private String artifactUrl;
    private String pomUrl;

    public MavenArtifact() {
    }

    public MavenArtifact(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public MavenArtifact(String groupId, String artifactId, String version, String url) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.artifactUrl = url;
    }

    public MavenArtifact(String groupId, String artifactId, String version, String artifactUrl, String pomUrl) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.artifactUrl = artifactUrl;
        this.pomUrl = pomUrl;
    }

    public static String derivePomUrl(String artifactId, String version, String artifactUrl) {
        return artifactUrl.substring(0, artifactUrl.lastIndexOf(47)) + '/' + artifactId + '-' + version + ".pom";
    }

    public String toString() {
        return String.format("%s:%s:%s", this.groupId, this.artifactId, this.version);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getArtifactUrl() {
        return this.artifactUrl;
    }

    public void setArtifactUrl(String artifactUrl) {
        this.artifactUrl = artifactUrl;
    }

    public String getPomUrl() {
        return this.pomUrl;
    }

    public void setPomUrl(String pomUrl) {
        this.pomUrl = pomUrl;
    }
}

