/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.authorization;

import java.util.StringTokenizer;
import org.pac4j.core.authorization.AuthorizationGenerator;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;

public class FromAttributesAuthorizationGenerator<U extends CommonProfile>
implements AuthorizationGenerator<U> {
    private final String[] roleAttributes;
    private final String[] permissionAttributes;
    private String splitChar = ",";

    public FromAttributesAuthorizationGenerator(String[] roleAttributes, String[] permissionAttributes) {
        this.roleAttributes = roleAttributes;
        this.permissionAttributes = permissionAttributes;
    }

    @Override
    public void generate(U profile) {
        this.generateAuth(profile, this.roleAttributes, true);
        this.generateAuth(profile, this.permissionAttributes, false);
    }

    private void generateAuth(U profile, String[] attributes, boolean isRole) {
        if (attributes != null) {
            for (String attribute : attributes) {
                Object value = ((UserProfile)profile).getAttribute(attribute);
                if (value == null || !(value instanceof String)) continue;
                StringTokenizer st = new StringTokenizer((String)value, this.splitChar);
                while (st.hasMoreTokens()) {
                    if (isRole) {
                        ((UserProfile)profile).addRole(st.nextToken());
                        continue;
                    }
                    ((UserProfile)profile).addPermission(st.nextToken());
                }
            }
        }
    }

    public String getSplitChar() {
        return this.splitChar;
    }

    public void setSplitChar(String splitChar) {
        this.splitChar = splitChar;
    }
}

