/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.context;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;

public class J2EContext
implements WebContext {
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public J2EContext(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    @Override
    public String getRequestParameter(String name) {
        return this.request.getParameter(name);
    }

    @Override
    public Map<String, String[]> getRequestParameters() {
        return this.request.getParameterMap();
    }

    @Override
    public String getRequestHeader(String name) {
        return this.request.getHeader(name);
    }

    @Override
    public void setSessionAttribute(String name, Object value) {
        this.request.getSession().setAttribute(name, value);
    }

    @Override
    public Object getSessionAttribute(String name) {
        return this.request.getSession().getAttribute(name);
    }

    @Override
    public String getRequestMethod() {
        return this.request.getMethod();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public void writeResponseContent(String content) {
        if (content != null) {
            try {
                this.response.getWriter().write(content);
            }
            catch (IOException e) {
                throw new TechnicalException(e);
            }
        }
    }

    @Override
    public void setResponseStatus(int code) {
        if (code == 200 || code == 302) {
            this.response.setStatus(code);
        } else {
            try {
                this.response.sendError(code);
            }
            catch (IOException e) {
                throw new TechnicalException(e);
            }
        }
    }

    @Override
    public void setResponseHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    @Override
    public String getServerName() {
        return this.request.getServerName();
    }

    @Override
    public int getServerPort() {
        return this.request.getServerPort();
    }

    @Override
    public String getScheme() {
        return this.request.getScheme();
    }

    @Override
    public String getFullRequestURL() {
        StringBuffer requestURL = this.request.getRequestURL();
        String queryString = this.request.getQueryString();
        if (queryString == null) {
            return requestURL.toString();
        }
        return requestURL.append('?').append(queryString).toString();
    }
}

