/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.engine;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.Generated;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.FrameworkParameters;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.AbstractExceptionAwareLogic;
import org.pac4j.core.engine.LogoutLogic;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.NoContentAction;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.logout.handler.SessionLogoutHandler;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLogoutLogic
extends AbstractExceptionAwareLogic
implements LogoutLogic {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLogoutLogic.class);
    public static final LogoutLogic INSTANCE = new DefaultLogoutLogic();

    @Override
    public Object perform(Config config, String defaultUrl, String inputLogoutUrlPattern, Boolean inputLocalLogout, Boolean inputDestroySession, Boolean inputCentralLogout, FrameworkParameters parameters) {
        HttpAction action;
        HttpActionAdapter httpActionAdapter;
        WebContext webContext;
        block10: {
            LOGGER.debug("=== LOGOUT ===");
            CallContext ctx = this.buildContext(config, parameters);
            webContext = ctx.webContext();
            httpActionAdapter = config.getHttpActionAdapter();
            CommonHelper.assertNotNull("httpActionAdapter", httpActionAdapter);
            try {
                SessionStore sessionStore = ctx.sessionStore();
                String logoutUrlPattern = Objects.requireNonNullElse(inputLogoutUrlPattern, "^(\\/|\\/[^\\/].*)$");
                boolean localLogout = inputLocalLogout == null || inputLocalLogout != false;
                boolean destroySession = inputDestroySession != null && inputDestroySession != false;
                boolean centralLogout = inputCentralLogout != null && inputCentralLogout != false;
                CommonHelper.assertNotBlank("logoutUrlPattern", logoutUrlPattern);
                Clients configClients = config.getClients();
                CommonHelper.assertNotNull("configClients", configClients);
                ProfileManager manager = (ProfileManager)ctx.profileManagerFactory().apply(webContext, sessionStore);
                manager.setConfig(config);
                List<UserProfile> profiles = manager.getProfiles();
                Optional<String> url = webContext.getRequestParameter("url");
                String redirectUrl = defaultUrl;
                if (url.isPresent() && Pattern.matches(logoutUrlPattern, url.get())) {
                    redirectUrl = url.get();
                }
                LOGGER.debug("redirectUrl: {}", (Object)redirectUrl);
                action = redirectUrl != null ? HttpActionHelper.buildRedirectUrlAction(webContext, redirectUrl) : NoContentAction.INSTANCE;
                if (localLogout || profiles.size() > 1) {
                    SessionLogoutHandler sessionLogoutHandler;
                    LOGGER.debug("Performing application logout");
                    manager.removeProfiles();
                    String sessionId = null;
                    if (sessionStore != null) {
                        boolean removed;
                        sessionId = sessionStore.getSessionId(webContext, false).orElse(null);
                        if (destroySession && !(removed = sessionStore.destroySession(webContext))) {
                            LOGGER.error("Unable to destroy the web session. The session store may not support this feature");
                        }
                    } else {
                        LOGGER.error("No session store available for this web context");
                    }
                    if ((sessionLogoutHandler = config.getSessionLogoutHandler()) != null && sessionId != null) {
                        sessionLogoutHandler.cleanRecord(sessionId);
                    }
                }
                if (!centralLogout) break block10;
                LOGGER.debug("Performing central logout");
                for (UserProfile profile : profiles) {
                    Optional<Client> client;
                    LOGGER.debug("Profile: {}", (Object)profile);
                    String clientName = profile.getClientName();
                    if (clientName == null || !(client = configClients.findClient(clientName)).isPresent()) continue;
                    String targetUrl = null;
                    if (redirectUrl != null && ((redirectUrl = this.enhanceRedirectUrl(ctx, config, client.get(), redirectUrl)).startsWith("http") || redirectUrl.startsWith("https"))) {
                        targetUrl = redirectUrl;
                    }
                    Optional<RedirectionAction> logoutAction = client.get().getLogoutAction(ctx, profile, targetUrl);
                    LOGGER.debug("Logout action: {}", logoutAction);
                    if (!logoutAction.isPresent()) continue;
                    action = logoutAction.get();
                    break;
                }
            }
            catch (RuntimeException e) {
                return this.handleException(e, httpActionAdapter, webContext);
            }
        }
        return httpActionAdapter.adapt(action, webContext);
    }

    protected String enhanceRedirectUrl(CallContext ctx, Config config, Client client, String redirectUrl) {
        return redirectUrl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "DefaultLogoutLogic(super=" + super.toString() + ")";
    }
}

