/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InitializableObject {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(InitializableObject.class);
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private int maxAttempts = 3;
    private AtomicInteger nbAttempts = new AtomicInteger(0);
    private volatile Long lastAttempt;
    private long minTimeIntervalBetweenAttemptsInMilliseconds = 5000L;

    public void init() {
        this.init(false);
    }

    public void reinit() {
        this.init(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(boolean forceReinit) {
        if (this.shouldInitialize(forceReinit)) {
            InitializableObject initializableObject = this;
            synchronized (initializableObject) {
                if (this.shouldInitialize(forceReinit)) {
                    LOGGER.debug("Initializing: {} (nb: {}, last: {})", new Object[]{this.getClass().getSimpleName(), this.nbAttempts, this.lastAttempt});
                    this.nbAttempts.incrementAndGet();
                    this.lastAttempt = System.currentTimeMillis();
                    this.beforeInternalInit(forceReinit);
                    this.internalInit(forceReinit);
                    this.afterInternalInit(forceReinit);
                    this.initialized.set(true);
                }
            }
        }
    }

    public final boolean isInitialized() {
        return this.initialized.get();
    }

    protected boolean shouldInitialize(boolean forceReinit) {
        if (forceReinit) {
            return true;
        }
        boolean notInitialized = !this.initialized.get();
        boolean notTooManyAttempts = this.maxAttempts == -1 || this.nbAttempts.get() < this.maxAttempts;
        boolean enoughTimeSinceLastAttempt = this.lastAttempt == null || System.currentTimeMillis() - this.lastAttempt > this.minTimeIntervalBetweenAttemptsInMilliseconds;
        return notInitialized && notTooManyAttempts && enoughTimeSinceLastAttempt;
    }

    protected abstract void internalInit(boolean var1);

    protected void beforeInternalInit(boolean forceReinit) {
    }

    protected void afterInternalInit(boolean forceReinit) {
    }

    public int getNbAttempts() {
        return this.nbAttempts.get();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "InitializableObject(initialized=" + this.initialized + ", maxAttempts=" + this.maxAttempts + ", nbAttempts=" + this.nbAttempts + ", lastAttempt=" + this.lastAttempt + ", minTimeIntervalBetweenAttemptsInMilliseconds=" + this.minTimeIntervalBetweenAttemptsInMilliseconds + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AtomicBoolean getInitialized() {
        return this.initialized;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Long getLastAttempt() {
        return this.lastAttempt;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getMinTimeIntervalBetweenAttemptsInMilliseconds() {
        return this.minTimeIntervalBetweenAttemptsInMilliseconds;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMinTimeIntervalBetweenAttemptsInMilliseconds(long minTimeIntervalBetweenAttemptsInMilliseconds) {
        this.minTimeIntervalBetweenAttemptsInMilliseconds = minTimeIntervalBetweenAttemptsInMilliseconds;
    }
}

