/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.BaseOAuth20Client;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.casoauthwrapper.CasOAuthWrapperProfile;
import org.scribe.builder.api.CasOAuthWrapperApi20;
import org.scribe.model.OAuthConfig;
import org.scribe.model.SignatureType;
import org.scribe.model.Token;
import org.scribe.oauth.ProxyOAuth20ServiceImpl;

public class CasOAuthWrapperClient
extends BaseOAuth20Client<CasOAuthWrapperProfile> {
    private String casOAuthUrl;
    private boolean springSecurityCompliant = false;

    public CasOAuthWrapperClient() {
    }

    public CasOAuthWrapperClient(String key, String secret, String casOAuthUrl) {
        this.setKey(key);
        this.setSecret(secret);
        this.casOAuthUrl = casOAuthUrl;
    }

    protected CasOAuthWrapperClient newClient() {
        CasOAuthWrapperClient newClient = new CasOAuthWrapperClient();
        newClient.setCasOAuthUrl(this.casOAuthUrl);
        newClient.setSpringSecurityCompliant(this.springSecurityCompliant);
        return newClient;
    }

    @Override
    protected void internalInit() {
        super.internalInit();
        CommonHelper.assertNotBlank((String)"casOAuthUrl", (String)this.casOAuthUrl);
        this.service = new ProxyOAuth20ServiceImpl(new CasOAuthWrapperApi20(this.casOAuthUrl, this.springSecurityCompliant), new OAuthConfig(this.key, this.secret, this.callbackUrl, SignatureType.Header, null, null), this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort, false, true);
    }

    @Override
    protected String getProfileUrl(Token accessToken) {
        return this.casOAuthUrl + "/profile";
    }

    @Override
    protected CasOAuthWrapperProfile extractUserProfile(String body) {
        CasOAuthWrapperProfile userProfile = new CasOAuthWrapperProfile();
        JsonNode json2 = JsonHelper.getFirstNode(body);
        if (json2 != null) {
            userProfile.setId(JsonHelper.get(json2, "id"));
            json2 = json2.get("attributes");
            if (json2 != null) {
                for (JsonNode json2 : json2) {
                    String attribute = (String)json2.fieldNames().next();
                    userProfile.addAttribute(attribute, JsonHelper.get(json2, attribute));
                }
            }
        }
        return userProfile;
    }

    public String getCasOAuthUrl() {
        return this.casOAuthUrl;
    }

    public void setCasOAuthUrl(String casOAuthUrl) {
        this.casOAuthUrl = casOAuthUrl;
    }

    public boolean isSpringSecurityCompliant() {
        return this.springSecurityCompliant;
    }

    public void setSpringSecurityCompliant(boolean springSecurityCompliant) {
        this.springSecurityCompliant = springSecurityCompliant;
    }

    @Override
    protected boolean requiresStateParameter() {
        return false;
    }

    @Override
    protected boolean hasBeenCancelled(WebContext context) {
        return false;
    }
}

