/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonList<T>
extends JsonObject
implements List<T> {
    private static final long serialVersionUID = -6244332281326848508L;
    private static final Logger logger = LoggerFactory.getLogger(JsonList.class);
    private List<T> list = new ArrayList<T>();
    private Class<T> clazz;

    public JsonList() {
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public void setClazz(Class<T> clazz) {
        this.clazz = clazz;
    }

    public JsonList(Object o, Class<T> clazz) {
        this.clazz = clazz;
        if (o instanceof List) {
            List elements = (List)o;
            for (String element : elements) {
                if (clazz == String.class && element != null && !element.startsWith("\"")) {
                    element = "\"" + element + "\"";
                }
                this.buildSingleNode(JsonHelper.getFirstNode(element));
            }
        } else {
            if (o instanceof String && o != null) {
                String s = (String)o;
                if (clazz == String.class) {
                    if (!s.startsWith("[")) {
                        if (!s.startsWith("\"")) {
                            s = "\"" + s + "\"";
                        }
                        s = "[" + s + "]";
                    }
                } else if (JsonObject.class.isAssignableFrom(clazz) && !s.startsWith("[")) {
                    s = "[" + s + "]";
                }
                o = s;
            }
            this.buildFrom(o);
        }
    }

    @Override
    protected void buildFromJson(JsonNode json) {
        if (json != null) {
            Iterator jsonIterator = json.elements();
            while (jsonIterator.hasNext()) {
                JsonNode node = (JsonNode)jsonIterator.next();
                this.buildSingleNode(node);
            }
        }
    }

    private void buildSingleNode(JsonNode node) {
        if (this.clazz == String.class) {
            this.list.add(node.textValue());
        } else if (JsonObject.class.isAssignableFrom(this.clazz)) {
            try {
                Constructor<T> constructor = this.clazz.getDeclaredConstructor(new Class[0]);
                T object = constructor.newInstance(new Object[0]);
                ((JsonObject)((Object)object)).buildFrom(node);
                this.list.add(object);
            }
            catch (Exception e) {
                logger.error("Cannot build object", (Throwable)e);
            }
        }
    }

    @Override
    public boolean add(T e) {
        return this.list.add(e);
    }

    @Override
    public void add(int index, T element) {
        this.list.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public T remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public T set(int index, T element) {
        return this.list.set(index, element);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }
}

