/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.callback;

import java.security.Principal;
import java.util.ArrayList;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.SecurityContext;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.callback.JBossCallbackHandler;
import org.jboss.security.auth.callback.SecurityActions;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.IdentityFactory;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleRole;
import org.jboss.security.identity.plugins.SimpleRoleGroup;

public class JASPICallbackHandler
extends JBossCallbackHandler {
    private static final long serialVersionUID = 1L;

    public JASPICallbackHandler() {
    }

    public JASPICallbackHandler(Principal principal, Object credential) {
        super(principal, credential);
    }

    protected void handleCallBack(Callback callback) throws UnsupportedCallbackException {
        if (callback instanceof GroupPrincipalCallback) {
            Subject subject;
            int sizeOfRoles;
            GroupPrincipalCallback groupPrincipalCallback = (GroupPrincipalCallback)callback;
            SecurityContext currentSC = SecurityActions.getCurrentSecurityContext();
            if (currentSC == null) {
                throw PicketBoxMessages.MESSAGES.invalidNullSecurityContext();
            }
            String[] rolesArray = groupPrincipalCallback.getGroups();
            int n = sizeOfRoles = rolesArray != null ? rolesArray.length : 0;
            if (sizeOfRoles > 0) {
                ArrayList<SimpleRole> rolesList = new ArrayList<SimpleRole>();
                for (int i = 0; i < sizeOfRoles; ++i) {
                    SimpleRole role = new SimpleRole(rolesArray[i]);
                    rolesList.add(role);
                }
                SimpleRoleGroup roles = new SimpleRoleGroup("Roles", rolesList);
                RoleGroup currentRoles = currentSC.getUtil().getRoles();
                if (currentRoles != null) {
                    currentRoles.addAll(roles.getRoles());
                } else {
                    currentSC.getUtil().setRoles((RoleGroup)roles);
                }
            }
            if ((subject = groupPrincipalCallback.getSubject()) != null) {
                Subject currentSubject = currentSC.getSubjectInfo().getAuthenticatedSubject();
                if (currentSubject != null) {
                    subject.getPrincipals().addAll(currentSubject.getPrincipals());
                    subject.getPublicCredentials().addAll(currentSubject.getPublicCredentials());
                    subject.getPrivateCredentials().addAll(currentSubject.getPrivateCredentials());
                }
                currentSC.getSubjectInfo().setAuthenticatedSubject(subject);
            }
        } else if (callback instanceof CallerPrincipalCallback) {
            Principal callerPrincipal;
            CallerPrincipalCallback callerPrincipalCallback = (CallerPrincipalCallback)callback;
            SecurityContext currentSC = SecurityActions.getCurrentSecurityContext();
            Subject subject = callerPrincipalCallback.getSubject();
            if (currentSC == null) {
                throw PicketBoxMessages.MESSAGES.invalidNullSecurityContext();
            }
            if (subject != null) {
                Subject currentSubject = currentSC.getSubjectInfo().getAuthenticatedSubject();
                if (currentSubject != null) {
                    subject.getPrincipals().addAll(currentSubject.getPrincipals());
                    subject.getPublicCredentials().addAll(currentSubject.getPublicCredentials());
                    subject.getPrivateCredentials().addAll(currentSubject.getPrivateCredentials());
                }
                currentSC.getSubjectInfo().setAuthenticatedSubject(subject);
            }
            if ((callerPrincipal = callerPrincipalCallback.getPrincipal()) == null && callerPrincipalCallback.getName() != null) {
                callerPrincipal = new SimplePrincipal(callerPrincipalCallback.getName());
            }
            if (callerPrincipal != null) {
                Subject currentSubject = currentSC.getSubjectInfo().getAuthenticatedSubject();
                if (currentSubject != null) {
                    currentSubject.getPrincipals().add(callerPrincipal);
                }
                Identity principalBasedIdentity = IdentityFactory.getIdentity((Principal)callerPrincipal, null);
                currentSC.getSubjectInfo().addIdentity(principalBasedIdentity);
            }
        } else if (callback instanceof PasswordValidationCallback) {
            PasswordValidationCallback passwordValidationCallback = (PasswordValidationCallback)callback;
            SecurityContext currentSC = SecurityActions.getCurrentSecurityContext();
            if (currentSC == null) {
                throw PicketBoxMessages.MESSAGES.invalidNullSecurityContext();
            }
            String userName = passwordValidationCallback.getUsername();
            char[] password = passwordValidationCallback.getPassword();
            Subject subject = passwordValidationCallback.getSubject();
            if (subject != null) {
                Subject currentSubject = currentSC.getSubjectInfo().getAuthenticatedSubject();
                if (currentSubject != null) {
                    subject.getPrincipals().addAll(currentSubject.getPrincipals());
                    subject.getPublicCredentials().addAll(currentSubject.getPublicCredentials());
                    subject.getPrivateCredentials().addAll(currentSubject.getPrivateCredentials());
                }
                currentSC.getSubjectInfo().setAuthenticatedSubject(subject);
                Identity identity = IdentityFactory.getIdentity((Principal)new SimplePrincipal(userName), (Object)password);
                currentSC.getSubjectInfo().addIdentity(identity);
            }
        } else {
            super.handleCallBack(callback);
        }
    }
}

