/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.credential;

import javax.enterprise.context.RequestScoped;
import javax.inject.Named;
import org.picketlink.idm.credential.AbstractBaseCredentials;
import org.picketlink.idm.credential.Password;

@Named(value="loginCredentials")
@RequestScoped
public class DefaultLoginCredentials
extends AbstractBaseCredentials {
    private Object credential;
    private String userId;

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        if (userId == null) {
            throw new IllegalArgumentException("User id can not be null.");
        }
        this.userId = userId;
    }

    public Object getCredential() {
        return this.credential;
    }

    public void setCredential(Object credential) {
        this.credential = credential;
    }

    public String getPassword() {
        if (this.credential != null && this.credential instanceof Password) {
            Password ptp = (Password)this.credential;
            return new String(ptp.getValue());
        }
        return null;
    }

    public void setPassword(String password) {
        if (password == null) {
            throw new IllegalArgumentException("Password can not be null.");
        }
        this.credential = new Password(password.toCharArray());
    }

    public void invalidate() {
        this.credential = null;
        this.userId = null;
    }

    public String toString() {
        return "DefaultLoginCredentials[" + (this.userId != null ? this.userId : "unknown") + "]";
    }
}

