/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.PropertyQuery;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdGenerator;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.event.EventBridge;
import org.picketlink.idm.internal.AbstractIdentityContext;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.annotation.Unique;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.internal.DefaultIdentityQuery;
import org.picketlink.idm.spi.AttributeStore;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.StoreSelector;

public class ContextualIdentityManager
extends AbstractIdentityContext
implements IdentityManager {
    private final StoreSelector storeSelector;
    private final RelationshipManager relationshipManager;

    public ContextualIdentityManager(Partition partition, EventBridge eventBridge, IdGenerator idGenerator, StoreSelector storeSelector, RelationshipManager relationshipManager) {
        super(partition, eventBridge, idGenerator);
        this.storeSelector = storeSelector;
        this.setParameter("IDENTITY_MANAGER_CTX_PARAMETER", this);
        this.relationshipManager = relationshipManager;
    }

    public void add(IdentityType identityType) throws IdentityManagementException {
        this.checkUniqueness(identityType);
        try {
            this.storeSelector.getStoreForIdentityOperation((IdentityContext)this, IdentityStore.class, identityType.getClass(), IdentityStoreConfiguration.IdentityOperation.create).add((IdentityContext)this, (AttributedType)identityType);
            this.addAttributes(identityType);
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.attributedTypeAddFailed((AttributedType)identityType, (Throwable)e);
        }
    }

    public void update(IdentityType identityType) throws IdentityManagementException {
        this.checkIfIdentityTypeExists(identityType);
        try {
            this.storeSelector.getStoreForIdentityOperation((IdentityContext)this, IdentityStore.class, IdentityType.class, IdentityStoreConfiguration.IdentityOperation.update).update((IdentityContext)this, (AttributedType)identityType);
            this.removeAttributes(identityType);
            this.addAttributes(identityType);
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.attributedTypeUpdateFailed((AttributedType)identityType, (Throwable)e);
        }
    }

    public void remove(IdentityType identityType) throws IdentityManagementException {
        this.checkIfIdentityTypeExists(identityType);
        try {
            RelationshipQuery query = this.relationshipManager.createRelationshipQuery(Relationship.class);
            query.setParameter(Relationship.IDENTITY, new Object[]{identityType});
            for (Relationship relationship : query.getResultList()) {
                this.relationshipManager.remove(relationship);
            }
            this.removeAllAttributes(identityType);
            this.storeSelector.getStoreForIdentityOperation((IdentityContext)this, IdentityStore.class, IdentityType.class, IdentityStoreConfiguration.IdentityOperation.delete).remove((IdentityContext)this, (AttributedType)identityType);
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.attributedTypeRemoveFailed((AttributedType)identityType, (Throwable)e);
        }
    }

    public <T extends IdentityType> T lookupIdentityById(Class<T> identityType, String id) {
        if (identityType == null) {
            throw IDMMessages.MESSAGES.nullArgument("IdentityType class");
        }
        if (identityType == null) {
            throw IDMMessages.MESSAGES.nullArgument("Identifier");
        }
        IdentityQuery<T> query = this.createIdentityQuery(identityType);
        query.setParameter(IdentityType.ID, new Object[]{id});
        List result = query.getResultList();
        IdentityType identity = null;
        if (!result.isEmpty()) {
            if (result.size() > 1) {
                throw IDMMessages.MESSAGES.attributedTypeAmbiguosFoundWithId(id);
            }
            identity = (IdentityType)result.get(0);
        }
        return (T)identity;
    }

    public <T extends IdentityType> IdentityQuery<T> createIdentityQuery(Class<T> identityType) {
        if (identityType == null) {
            throw IDMMessages.MESSAGES.nullArgument("IdentityType class");
        }
        return new DefaultIdentityQuery<T>(this, identityType, this.storeSelector);
    }

    public void validateCredentials(Credentials credentials) {
        if (credentials == null) {
            throw IDMMessages.MESSAGES.nullArgument("Credentials");
        }
        this.storeSelector.getStoreForCredentialOperation((IdentityContext)this, credentials.getClass()).validateCredentials((IdentityContext)this, credentials);
    }

    public void updateCredential(Account account, Object credential) {
        this.updateCredential(account, credential, null, null);
    }

    public void updateCredential(Account account, Object credential, Date effectiveDate, Date expiryDate) {
        this.checkIfIdentityTypeExists((IdentityType)account);
        if (credential == null) {
            throw IDMMessages.MESSAGES.nullArgument("Credential");
        }
        this.storeSelector.getStoreForCredentialOperation((IdentityContext)this, credential.getClass()).updateCredential((IdentityContext)this, account, credential, effectiveDate, expiryDate);
    }

    public <T extends CredentialStorage> T retrieveCurrentCredential(Account account, Class<T> storageClass) {
        this.checkIfIdentityTypeExists((IdentityType)account);
        if (storageClass == null) {
            throw IDMMessages.MESSAGES.nullArgument("CredentialStorage type");
        }
        for (CredentialStore credentialStore : this.storeSelector.getStoresForCredentialStorage((IdentityContext)this, storageClass)) {
            CredentialStorage credentialStorage = credentialStore.retrieveCurrentCredential((IdentityContext)this, account, storageClass);
            if (credentialStorage == null) continue;
            return (T)credentialStorage;
        }
        return null;
    }

    public <T extends CredentialStorage> List<T> retrieveCredentials(Account account, Class<T> storageClass) {
        this.checkIfIdentityTypeExists((IdentityType)account);
        if (storageClass == null) {
            throw IDMMessages.MESSAGES.nullArgument("CredentialStorage type");
        }
        ArrayList storages = new ArrayList();
        for (CredentialStore credentialStore : this.storeSelector.getStoresForCredentialStorage((IdentityContext)this, storageClass)) {
            storages.addAll(credentialStore.retrieveCredentials((IdentityContext)this, account, storageClass));
        }
        return storages;
    }

    private void checkUniqueness(IdentityType identityType) {
        if (identityType == null) {
            throw IDMMessages.MESSAGES.nullArgument("IdentityType");
        }
        PropertyQuery propertyQuery = PropertyQueries.createQuery(identityType.getClass());
        propertyQuery.addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(Unique.class));
        IdentityQuery<?> identityQuery = this.createIdentityQuery(identityType.getClass());
        for (Property property : propertyQuery.getResultList()) {
            identityQuery.setParameter((QueryParameter)AttributedType.QUERY_ATTRIBUTE.byName((String)property.getName()), new Object[]{property.getValue((Object)identityType)});
        }
        if (!identityQuery.getResultList().isEmpty()) {
            throw IDMMessages.MESSAGES.identityTypeAlreadyExists(identityType.getClass(), identityType.toString(), this.getPartition());
        }
    }

    private void checkIfIdentityTypeExists(IdentityType identityType) throws IdentityManagementException {
        if (identityType == null) {
            throw IDMMessages.MESSAGES.nullArgument("IdentityType");
        }
        if (this.lookupIdentityById(identityType.getClass(), identityType.getId()) == null) {
            throw IDMMessages.MESSAGES.attributedTypeNotFoundWithId(identityType.getClass(), identityType.getId(), this.getPartition());
        }
    }

    private void removeAllAttributes(IdentityType identityType) {
        Object storedType;
        AttributeStore attributeStore = this.storeSelector.getStoreForAttributeOperation((IdentityContext)this);
        if (attributeStore != null && (storedType = this.lookupIdentityById(identityType.getClass(), identityType.getId())) != null) {
            for (Attribute attribute : storedType.getAttributes()) {
                attributeStore.removeAttribute((IdentityContext)this, (AttributedType)identityType, attribute.getName());
            }
        }
    }

    private void addAttributes(IdentityType identityType) {
        AttributeStore attributeStore = this.storeSelector.getStoreForAttributeOperation((IdentityContext)this);
        if (attributeStore != null) {
            for (Attribute attribute : identityType.getAttributes()) {
                attributeStore.setAttribute((IdentityContext)this, (AttributedType)identityType, attribute);
            }
        }
    }

    private void removeAttributes(IdentityType identityType) {
        Object storedType;
        AttributeStore attributeStore = this.storeSelector.getStoreForAttributeOperation((IdentityContext)this);
        if (attributeStore != null && (storedType = this.lookupIdentityById(identityType.getClass(), identityType.getId())) != null) {
            for (Attribute attribute : storedType.getAttributes()) {
                if (identityType.getAttribute(attribute.getName()) != null) continue;
                attributeStore.removeAttribute((IdentityContext)this, (AttributedType)identityType, attribute.getName());
            }
        }
    }
}

