/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.picketlink.idm.IDMInternalMessages;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.PermissionManager;
import org.picketlink.idm.internal.DefaultIdentityContext;
import org.picketlink.idm.internal.DefaultPartitionManager;
import org.picketlink.idm.internal.IdentityTypeReference;
import org.picketlink.idm.internal.util.IdentityTypeUtil;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.permission.IdentityPermission;
import org.picketlink.idm.permission.Permission;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.StoreSelector;

public class ContextualPermissionManager
implements PermissionManager {
    private final StoreSelector storeSelector;
    private final DefaultIdentityContext identityContext;
    private final PartitionManager partitionManager;

    public ContextualPermissionManager(Partition partition, DefaultPartitionManager defaultPartitionManager) {
        this.identityContext = new DefaultIdentityContext(partition, defaultPartitionManager.getEventBridge(), defaultPartitionManager.getIdGenerator(), defaultPartitionManager.getConfiguration().getPermissionHandlerPolicy());
        this.storeSelector = defaultPartitionManager.getStoreSelector();
        this.partitionManager = defaultPartitionManager;
        if (this.storeSelector.getStoreForPermissionOperation((IdentityContext)this.identityContext) == null) {
            throw IDMInternalMessages.MESSAGES.permissionUnsupportedOperation();
        }
    }

    public List<Permission> listPermissions(Object resource) {
        return this.resolveIdentityTypeReferences(this.storeSelector.getStoreForPermissionOperation((IdentityContext)this.identityContext).listPermissions((IdentityContext)this.identityContext, resource));
    }

    public List<Permission> listPermissions(Class<?> resourceClass, Serializable identifier) {
        return this.resolveIdentityTypeReferences(this.storeSelector.getStoreForPermissionOperation((IdentityContext)this.identityContext).listPermissions((IdentityContext)this.identityContext, resourceClass, identifier));
    }

    public List<Permission> listPermissions(Class<?> resourceClass, Serializable identifier, String operation) {
        return this.resolveIdentityTypeReferences(this.storeSelector.getStoreForPermissionOperation((IdentityContext)this.identityContext).listPermissions((IdentityContext)this.identityContext, resourceClass, identifier, operation));
    }

    public List<Permission> listPermissions(Object resource, String operation) {
        return this.resolveIdentityTypeReferences(this.storeSelector.getStoreForPermissionOperation((IdentityContext)this.identityContext).listPermissions((IdentityContext)this.identityContext, resource, operation));
    }

    public List<Permission> listPermissions(Class<?> resource, String operation) {
        return this.resolveIdentityTypeReferences(this.storeSelector.getStoreForPermissionOperation((IdentityContext)this.identityContext).listPermissions((IdentityContext)this.identityContext, resource, operation));
    }

    public List<Permission> listPermissions(IdentityType identityType) {
        return this.resolveIdentityTypeReferences(this.storeSelector.getStoreForPermissionOperation((IdentityContext)this.identityContext).listPermissions((IdentityContext)this.identityContext, identityType));
    }

    public void grantPermission(IdentityType assignee, Object resource, String operation) {
        try {
            this.storeSelector.getStoreForPermissionOperation((IdentityContext)this.identityContext).grantPermission((IdentityContext)this.identityContext, assignee, resource, operation);
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.permissionGrantFailed(assignee, resource, operation, (Throwable)e);
        }
    }

    public void revokePermission(IdentityType assignee, Object resource, String operation) {
        try {
            this.storeSelector.getStoreForPermissionOperation((IdentityContext)this.identityContext).revokePermission((IdentityContext)this.identityContext, assignee, resource, operation);
        }
        catch (Exception ex) {
            throw IDMMessages.MESSAGES.permissionRevokeFailed(assignee, resource, operation, (Throwable)ex);
        }
    }

    public void revokePermission(IdentityType assignee, Class<?> resourceclass, String operation) {
        try {
            this.storeSelector.getStoreForPermissionOperation((IdentityContext)this.identityContext).revokePermission((IdentityContext)this.identityContext, assignee, resourceclass, operation);
        }
        catch (Exception ex) {
            throw IDMMessages.MESSAGES.permissionRevokeFailed(assignee, resourceclass, operation, (Throwable)ex);
        }
    }

    public void clearPermissions(Object resource) {
        try {
            this.storeSelector.getStoreForPermissionOperation((IdentityContext)this.identityContext).revokeAllPermissions((IdentityContext)this.identityContext, resource);
        }
        catch (Exception ex) {
            throw IDMMessages.MESSAGES.permissionRevokeAllFailed(resource, (Throwable)ex);
        }
    }

    private List<Permission> resolveIdentityTypeReferences(List<Permission> permissions) {
        for (Permission permission : new ArrayList<Permission>(permissions)) {
            IdentityPermission identityPermission;
            IdentityType assignee;
            if (!IdentityPermission.class.isInstance(permission) || !IdentityTypeReference.class.isInstance(assignee = (identityPermission = (IdentityPermission)permission).getAssignee())) continue;
            IdentityTypeReference identityTypeReference = (IdentityTypeReference)assignee;
            IdentityType identityType = IdentityTypeUtil.resolveIdentityType(identityTypeReference.getId(), (Object)identityTypeReference, this.partitionManager);
            permissions.remove(permission);
            Object resource = identityPermission.getResource();
            if (resource != null) {
                permissions.add((Permission)new IdentityPermission(resource, identityType, identityPermission.getOperation()));
                continue;
            }
            permissions.add((Permission)new IdentityPermission(identityPermission.getResourceClass(), identityPermission.getResourceIdentifier(), identityType, identityPermission.getOperation()));
        }
        return permissions;
    }
}

