/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.annotations.CredentialHandlers;
import org.picketlink.idm.internal.util.IDMUtil;
import org.picketlink.idm.ldap.internal.LDAPAgent;
import org.picketlink.idm.ldap.internal.LDAPAttributedType;
import org.picketlink.idm.ldap.internal.LDAPCustomAttributes;
import org.picketlink.idm.ldap.internal.LDAPEntry;
import org.picketlink.idm.ldap.internal.LDAPGroup;
import org.picketlink.idm.ldap.internal.LDAPGroupRole;
import org.picketlink.idm.ldap.internal.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.ldap.internal.LDAPIdentityType;
import org.picketlink.idm.ldap.internal.LDAPOperationManager;
import org.picketlink.idm.ldap.internal.LDAPPlainTextPasswordCredentialHandler;
import org.picketlink.idm.ldap.internal.LDAPQuery;
import org.picketlink.idm.ldap.internal.LDAPRole;
import org.picketlink.idm.ldap.internal.LDAPUser;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupMembership;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleAgent;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.internal.DefaultIdentityQuery;
import org.picketlink.idm.query.internal.DefaultRelationshipQuery;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;

@CredentialHandlers(value={LDAPPlainTextPasswordCredentialHandler.class})
public class LDAPIdentityStore
implements IdentityStore<LDAPIdentityStoreConfiguration> {
    private LDAPIdentityStoreConfiguration configuration;
    private IdentityStoreInvocationContext context;

    public void setup(LDAPIdentityStoreConfiguration config, IdentityStoreInvocationContext context) {
        this.configuration = config;
        this.context = context;
        if (context == null) {
            throw new IdentityManagementException("IdentityStoreInvocationContext is null.");
        }
        if (this.context.getRealm() == null) {
            this.context.setRealm(new Realm("default"));
        }
    }

    public LDAPIdentityStoreConfiguration getConfig() {
        return this.configuration;
    }

    public IdentityStoreInvocationContext getContext() {
        return this.context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(AttributedType attributedType) {
        if (IdentityType.class.isInstance(attributedType)) {
            IdentityType identityType = (IdentityType)attributedType;
            identityType.setPartition((Partition)this.getContext().getRealm());
            if (Agent.class.isInstance(attributedType)) {
                Agent newAgent = (Agent)attributedType;
                if (newAgent.getLoginName() == null) {
                    throw new IdentityManagementException("No login name was provided.");
                }
                if (User.class.isInstance(attributedType)) {
                    if (this.getUser(newAgent.getLoginName()) != null) {
                        throw new IdentityManagementException("User already exists with the given login name [" + newAgent.getLoginName() + "] for the given Realm [" + this.getContext().getRealm().getName() + "]");
                    }
                    User newUser = (User)attributedType;
                    this.addUser(newUser);
                    return;
                } else {
                    if (this.getAgent(newAgent.getLoginName()) != null) {
                        throw new IdentityManagementException("Agent already exists with the given login name [" + newAgent.getLoginName() + "] for the given Realm [" + this.getContext().getRealm().getName() + "]");
                    }
                    this.addAgent(newAgent);
                }
                return;
            } else if (Role.class.isInstance(attributedType)) {
                Role newRole = (Role)attributedType;
                this.addRole(newRole);
                return;
            } else {
                if (!Group.class.isInstance(attributedType)) throw this.createUnsupportedIdentityTypeException(identityType.getClass());
                Group newGroup = (Group)attributedType;
                this.addGroup(newGroup);
            }
            return;
        } else {
            if (!Relationship.class.isInstance(attributedType)) throw this.createUnsupportedAttributedType(attributedType.getClass());
            Relationship relationship = (Relationship)attributedType;
            if (Grant.class.isInstance(relationship)) {
                Grant grant = (Grant)relationship;
                this.addGrantRelationship(grant);
                return;
            } else {
                if (!GroupMembership.class.isInstance(relationship)) throw this.createUnsupportedRelationshipType(relationship.getClass());
                GroupMembership groupMembership = (GroupMembership)relationship;
                this.addGroupMembership(groupMembership);
                if (!GroupRole.class.isInstance(relationship)) return;
                GroupRole groupRole = (GroupRole)relationship;
                this.addGroupRoleRelationship(groupRole);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(AttributedType attributedType) {
        if (!IdentityType.class.isInstance(attributedType)) throw this.createUnsupportedAttributedType(attributedType.getClass());
        IdentityType identityType = (IdentityType)attributedType;
        if (Agent.class.isInstance(identityType)) {
            if (User.class.isInstance(identityType)) {
                User updatedUser = (User)identityType;
                this.updateUser(updatedUser);
                return;
            } else {
                Agent updatedAgent = (Agent)identityType;
                this.updateAgent(updatedAgent);
            }
            return;
        } else if (Role.class.isInstance(identityType)) {
            Role updatedRole = (Role)identityType;
            this.updateRole(updatedRole);
            return;
        } else {
            if (!Group.class.isInstance(identityType)) throw this.createUnsupportedIdentityTypeException(identityType.getClass());
            Group updatedGroup = (Group)identityType;
            this.updateGroup(updatedGroup);
        }
    }

    public void remove(AttributedType attributedType) {
        if (IdentityType.class.isInstance(attributedType)) {
            IdentityType identityType = (IdentityType)attributedType;
            if (identityType.getId() == null) {
                throw new IdentityManagementException("No identifier provided.");
            }
            if (Agent.class.isInstance(identityType)) {
                this.removeAgentRelationships((Agent)identityType);
            }
            String baseDN = this.getBaseDN(identityType.getClass());
            if (Group.class.isInstance(attributedType)) {
                Group group = (Group)attributedType;
                baseDN = this.getGroupBaseDN(group.getPath());
            }
            this.getLDAPManager().removeEntryById(baseDN, identityType.getId());
        } else if (Relationship.class.isInstance(attributedType)) {
            Relationship relationship = (Relationship)attributedType;
            if (Grant.class.isInstance(relationship)) {
                this.removeGrantRelationship((Grant)relationship);
            } else if (GroupMembership.class.isInstance(relationship)) {
                GroupMembership groupMembership = (GroupMembership)relationship;
                this.removeGroupMembership(groupMembership);
                if (GroupRole.class.isInstance(groupMembership)) {
                    GroupRole groupRole = (GroupRole)groupMembership;
                    this.removeGroupRoleRelationship(groupMembership, groupRole);
                }
            }
        }
    }

    public Agent getAgent(String loginName) {
        LDAPAgent ldapAgent;
        User agent = null;
        if (loginName != null && (ldapAgent = this.lookupAgent(loginName)) != null) {
            if (LDAPUser.class.isInstance(ldapAgent)) {
                agent = this.getUser(loginName);
            } else {
                agent = new SimpleAgent(ldapAgent.getLoginName());
                agent.setLoginName(ldapAgent.getLoginName());
                this.populateIdentityType(ldapAgent, (IdentityType)agent);
            }
        }
        return agent;
    }

    public User getUser(String loginName) {
        LDAPUser ldapUser;
        if (loginName != null && (ldapUser = this.lookupUser(loginName)) != null) {
            SimpleUser user = new SimpleUser(ldapUser.getLoginName());
            user.setLoginName(ldapUser.getLoginName());
            user.setFirstName(ldapUser.getFirstName());
            user.setLastName(ldapUser.getLastName());
            user.setEmail(ldapUser.getEmail());
            this.populateIdentityType(ldapUser, (IdentityType)user);
            return user;
        }
        return null;
    }

    public Group getGroup(String groupPath) {
        if (groupPath == null) {
            return null;
        }
        return this.getGroup(groupPath, this.getGroupBaseDN(groupPath));
    }

    public Group getGroup(String groupPath, String baseDN) {
        LDAPGroup ldapGroup;
        if (groupPath != null && (ldapGroup = this.lookupGroup(groupPath, baseDN)) != null) {
            SimpleGroup group = new SimpleGroup(ldapGroup.getName(), this.getParentGroup(ldapGroup));
            this.populateIdentityType(ldapGroup, (IdentityType)group);
            return group;
        }
        return null;
    }

    public Group getGroup(String name, Group parent) {
        Group group = this.getGroup(parent.getPath() + "/" + name);
        if (group.getParentGroup() == null || !group.getParentGroup().getName().equals(parent.getName())) {
            group = null;
        }
        return group;
    }

    public Role getRole(String name) {
        LDAPRole ldapRole;
        if (name != null && (ldapRole = this.lookupRole(name)) != null) {
            SimpleRole role = new SimpleRole(ldapRole.getName());
            this.populateIdentityType(ldapRole, (IdentityType)role);
            return role;
        }
        return null;
    }

    public <T extends IdentityType> List<T> fetchQueryResults(IdentityQuery<T> identityQuery) {
        String relationshipFilter;
        LDAPQuery ldapQuery = new LDAPQuery(identityQuery, this);
        StringBuffer searchFilter = ldapQuery.createManagedAttributesFilter();
        if (searchFilter == null) {
            searchFilter = new StringBuffer("(&(objectClass=*))");
        }
        if ((relationshipFilter = ldapQuery.createRelationshipFilter()).isEmpty() && ldapQuery.hasRelationshipParameters()) {
            return Collections.emptyList();
        }
        String idAttribute = this.getIdAttribute(identityQuery.getIdentityType());
        if (idAttribute != null) {
            searchFilter.insert(searchFilter.length() - 1, "(" + idAttribute + "=*)");
        }
        searchFilter.insert(searchFilter.length() - 1, "(!(cn=custom-attributes))");
        searchFilter.insert(searchFilter.length() - 1, relationshipFilter.toString());
        NamingEnumeration<SearchResult> answer = null;
        ArrayList<User> results = new ArrayList<User>();
        try {
            String baseDN = this.getBaseDN(identityQuery.getIdentityType());
            if (identityQuery.getParameter(AttributedType.ID) != null) {
                baseDN = this.getConfig().getBaseDN();
            }
            answer = this.getLDAPManager().search(baseDN, searchFilter.toString());
            while (answer.hasMore()) {
                Object[] values;
                SearchResult sr = answer.next();
                String nameInNamespace = sr.getNameInNamespace();
                String[] names = nameInNamespace.split(",");
                String uid = names[0].split("=")[1];
                User ldapEntry = null;
                if (nameInNamespace.endsWith(this.getConfig().getUserDNSuffix())) {
                    ldapEntry = this.getUser(uid);
                } else if (nameInNamespace.endsWith(this.getConfig().getAgentDNSuffix())) {
                    ldapEntry = this.getAgent(uid);
                } else if (nameInNamespace.endsWith(this.getConfig().getRoleDNSuffix())) {
                    ldapEntry = this.getRole(uid);
                } else if (nameInNamespace.endsWith(this.getConfig().getGroupDNSuffix())) {
                    ldapEntry = this.getGroup(uid);
                }
                if (identityQuery.getParameters().containsKey(IdentityType.ENABLED)) {
                    values = (Object[])identityQuery.getParameters().get(IdentityType.ENABLED);
                    if (!String.valueOf(ldapEntry.isEnabled()).equals(values[0].toString())) continue;
                }
                if (identityQuery.getParameters().containsKey(IdentityType.EXPIRY_DATE) || identityQuery.getParameters().containsKey(IdentityType.EXPIRY_BEFORE) || identityQuery.getParameters().containsKey(IdentityType.EXPIRY_AFTER)) {
                    long providedDateInMillis;
                    long storedDateInMillis;
                    if (ldapEntry.getExpirationDate() == null) continue;
                    if (identityQuery.getParameters().containsKey(IdentityType.EXPIRY_DATE)) {
                        values = (Object[])identityQuery.getParameters().get(IdentityType.EXPIRY_DATE);
                        storedDateInMillis = ldapEntry.getExpirationDate().getTime();
                        if (storedDateInMillis != (providedDateInMillis = ((Date)values[0]).getTime())) continue;
                    }
                    if (identityQuery.getParameters().containsKey(IdentityType.EXPIRY_BEFORE)) {
                        values = (Object[])identityQuery.getParameters().get(IdentityType.EXPIRY_BEFORE);
                        storedDateInMillis = ldapEntry.getExpirationDate().getTime();
                        if (storedDateInMillis > (providedDateInMillis = ((Date)values[0]).getTime())) continue;
                    }
                    if (identityQuery.getParameters().containsKey(IdentityType.EXPIRY_AFTER)) {
                        values = (Object[])identityQuery.getParameters().get(IdentityType.EXPIRY_AFTER);
                        storedDateInMillis = ldapEntry.getExpirationDate().getTime();
                        if (storedDateInMillis < (providedDateInMillis = ((Date)values[0]).getTime())) continue;
                    }
                }
                boolean match = true;
                Set parameters = identityQuery.getParameters(AttributedType.AttributeParameter.class).entrySet();
                for (Map.Entry ldapQueryParameter : parameters) {
                    QueryParameter queryParameter = (QueryParameter)ldapQueryParameter.getKey();
                    Object[] values2 = (Object[])ldapQueryParameter.getValue();
                    match = false;
                    AttributedType.AttributeParameter customParameter = (AttributedType.AttributeParameter)queryParameter;
                    Attribute customParameterValue = ldapEntry.getAttribute(customParameter.getName());
                    if (ldapEntry.getAttribute(customParameter.getName()) == null) continue;
                    int count = values2.length;
                    for (Object parameterValue : values2) {
                        if (customParameterValue.getValue().getClass().isArray()) {
                            Object[] customParameterValues;
                            for (Object value : customParameterValues = (Object[])customParameterValue.getValue()) {
                                if (!value.equals(parameterValue)) continue;
                                --count;
                            }
                            continue;
                        }
                        if (!parameterValue.equals(customParameterValue.getValue())) continue;
                        --count;
                    }
                    match = count <= 0;
                    if (match) continue;
                    break;
                }
                if (!match || ldapEntry == null) continue;
                results.add(ldapEntry);
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error during query execution.", (Throwable)e);
        }
        finally {
            if (answer != null) {
                try {
                    answer.close();
                }
                catch (NamingException e) {}
            }
        }
        return results;
    }

    public <T extends IdentityType> int countQueryResults(IdentityQuery<T> identityQuery) {
        int limit = identityQuery.getLimit();
        int offset = identityQuery.getOffset();
        identityQuery.setLimit(0);
        identityQuery.setOffset(0);
        int resultCount = identityQuery.getResultList().size();
        identityQuery.setLimit(limit);
        identityQuery.setOffset(offset);
        return resultCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T extends Relationship> List<T> fetchQueryResults(RelationshipQuery<T> query) {
        LDAPGroup groupEntry;
        ArrayList<Object> results = new ArrayList<Object>();
        Class relationshipType = query.getRelationshipType();
        if (Grant.class.equals((Object)relationshipType)) {
            Agent agent = null;
            if (query.getParameter((QueryParameter)Grant.ASSIGNEE) != null) {
                agent = (Agent)query.getParameter((QueryParameter)Grant.ASSIGNEE)[0];
            }
            Role role = null;
            if (query.getParameter((QueryParameter)Grant.ROLE) != null) {
                role = (Role)query.getParameter((QueryParameter)Grant.ROLE)[0];
            }
            if (agent != null && role != null) {
                LDAPAgent agentEntry = this.lookupAgent(agent);
                LDAPRole roleEntry = this.lookupRole(role.getName());
                if (!roleEntry.isMember(agentEntry)) return results;
                results.add(new Grant((IdentityType)agent, role));
                return results;
            } else if (agent != null) {
                DefaultIdentityQuery<Role> rolesOf = new DefaultIdentityQuery<Role>(Role.class, this);
                rolesOf.setParameter(Role.ROLE_OF, new Object[]{agent});
                List result = rolesOf.getResultList();
                for (Role grantedRole : result) {
                    results.add(new Grant((IdentityType)agent, grantedRole));
                }
                return results;
            } else {
                if (role == null) return results;
                DefaultIdentityQuery<User> rolesOf = new DefaultIdentityQuery<User>(User.class, this);
                rolesOf.setParameter(Role.HAS_ROLE, new Object[]{role.getName()});
                List result = rolesOf.getResultList();
                for (User user : result) {
                    results.add(new Grant((IdentityType)user, role));
                }
            }
            return results;
        }
        if (GroupMembership.class.equals((Object)relationshipType)) {
            Agent agent = null;
            if (query.getParameter((QueryParameter)GroupMembership.MEMBER) != null) {
                agent = (Agent)query.getParameter((QueryParameter)GroupMembership.MEMBER)[0];
            }
            Group group = null;
            if (query.getParameter((QueryParameter)GroupMembership.GROUP) != null) {
                group = (Group)query.getParameter((QueryParameter)GroupMembership.GROUP)[0];
            }
            if (agent != null && group != null) {
                LDAPGroup groupEntry2 = this.lookupGroup(group.getPath());
                LDAPAgent agentEntry = this.lookupAgent(agent);
                if (agentEntry == null || !groupEntry2.isMember(agentEntry)) return results;
                results.add(new GroupMembership((IdentityType)agent, group));
                return results;
            } else if (agent != null) {
                DefaultIdentityQuery<Group> groupsOf = new DefaultIdentityQuery<Group>(Group.class, this);
                groupsOf.setParameter(Group.HAS_MEMBER, new Object[]{agent});
                List result = groupsOf.getResultList();
                for (Group grantedRole : result) {
                    results.add(new GroupMembership((IdentityType)agent, grantedRole));
                }
                return results;
            } else {
                if (group == null) return results;
                DefaultIdentityQuery<User> groupsOf = new DefaultIdentityQuery<User>(User.class, this);
                groupsOf.setParameter(User.MEMBER_OF, new Object[]{group.getName()});
                List result = groupsOf.getResultList();
                for (User user : result) {
                    results.add(new GroupMembership((IdentityType)user, group));
                }
            }
            return results;
        }
        if (!GroupRole.class.equals((Object)relationshipType)) return results;
        Agent agent = null;
        if (query.getParameter((QueryParameter)GroupRole.MEMBER) != null) {
            agent = (Agent)query.getParameter((QueryParameter)GroupRole.MEMBER)[0];
        }
        Role role = null;
        if (query.getParameter((QueryParameter)GroupRole.ROLE) != null) {
            role = (Role)query.getParameter((QueryParameter)GroupRole.ROLE)[0];
        }
        Group group = null;
        if (query.getParameter((QueryParameter)GroupRole.GROUP) != null) {
            group = (Group)query.getParameter((QueryParameter)GroupRole.GROUP)[0];
        }
        if (agent != null && group != null && role != null) {
            LDAPGroup groupEntry3 = this.lookupGroup(group.getName());
            LDAPRole roleEntry = this.lookupRole(role.getName());
            LDAPAgent agentEntry = this.lookupAgent(agent);
            if (agentEntry == null || groupEntry3 == null || roleEntry == null) return results;
            LDAPGroupRole groupRoleEntry = null;
            NamingEnumeration<SearchResult> groupRoleAttributes = this.lookupGroupRoleEntry(agentEntry, groupEntry3);
            try {
                if (!groupRoleAttributes.hasMore()) return results;
                groupRoleEntry = new LDAPGroupRole(agentEntry, groupEntry3, roleEntry);
                groupRoleEntry.setLDAPAttributes(groupRoleAttributes.next().getAttributes());
                if (!groupRoleEntry.isMember(roleEntry)) return results;
                results.add(new GroupRole((IdentityType)agent, group, role));
                return results;
            }
            catch (Exception e) {
                throw new IdentityManagementException((Throwable)e);
            }
            finally {
                try {
                    groupRoleAttributes.close();
                }
                catch (NamingException e) {}
            }
        }
        if (agent != null && role == null && group == null) {
            LDAPAgent agentEntry = this.lookupAgent(agent);
            if (agentEntry == null) return results;
            NamingEnumeration<SearchResult> search = this.getLDAPManager().search(agentEntry.getDN(), "(&(objectClass=*)(cn=*)(member=*))");
            try {
                while (search.hasMore()) {
                    javax.naming.directory.Attribute members;
                    SearchResult next = search.next();
                    String groupName = (String)next.getAttributes().get("cn").get();
                    Group associatedGroup = this.getGroup(groupName);
                    if (associatedGroup == null || (members = next.getAttributes().get("member")) == null || members.size() <= 0) continue;
                    NamingEnumeration<?> allRoles = members.getAll();
                    Role associatedRole = null;
                    while (allRoles.hasMoreElements()) {
                        String roleDN = (String)allRoles.nextElement();
                        String roleName = roleDN.substring(roleDN.indexOf("=") + 1, roleDN.indexOf(","));
                        associatedRole = this.getRole(roleName);
                        results.add(new GroupRole((IdentityType)agent, associatedGroup, associatedRole));
                    }
                }
                return results;
            }
            catch (Exception e) {
                throw new IdentityManagementException((Throwable)e);
            }
            finally {
                try {
                    search.close();
                }
                catch (NamingException e) {}
            }
        }
        if (role != null) {
            LDAPRole roleEntry = this.lookupRole(role.getName());
            if (roleEntry == null) return results;
            NamingEnumeration<SearchResult> search = this.getLDAPManager().search(this.getConfig().getUserDNSuffix(), "(&(objectClass=*)(cn=*)(member=" + roleEntry.getDN() + "))");
            try {
                while (search.hasMore()) {
                    SearchResult next = search.next();
                    String groupName = (String)next.getAttributes().get("cn").get();
                    Group associatedGroup = this.getGroup(groupName);
                    Role associatedRole = this.getRole(roleEntry.getName());
                    if (associatedGroup == null || associatedRole == null) continue;
                    results.add(new GroupRole((IdentityType)agent, associatedGroup, associatedRole));
                }
                return results;
            }
            catch (Exception e) {
                throw new IdentityManagementException((Throwable)e);
            }
            finally {
                try {
                    search.close();
                }
                catch (NamingException e) {}
            }
        }
        if (group == null || (groupEntry = this.lookupGroup(group.getName())) == null) return results;
        String filter = "(&(objectClass=*)(" + groupEntry.getBidingName() + ")(" + "member" + "=" + "*))";
        NamingEnumeration<SearchResult> search = this.getLDAPManager().search(this.getConfig().getUserDNSuffix(), filter);
        try {
            while (search.hasMore()) {
                SearchResult next = search.next();
                String groupName = (String)next.getAttributes().get("cn").get();
                Group associatedGroup = this.getGroup(groupName);
                if (associatedGroup == null) continue;
                String nameInNamespace = next.getNameInNamespace();
                String userDN = nameInNamespace.substring(nameInNamespace.indexOf("uid"));
                String userName = userDN.substring(userDN.indexOf("=") + 1, userDN.indexOf(","));
                agent = this.getAgent(userName);
                javax.naming.directory.Attribute members = next.getAttributes().get("member");
                if (members == null || members.size() <= 0) continue;
                NamingEnumeration<?> allRoles = members.getAll();
                Role associatedRole = null;
                while (allRoles.hasMoreElements()) {
                    String roleDN = (String)allRoles.nextElement();
                    String roleName = roleDN.substring(roleDN.indexOf("=") + 1, roleDN.indexOf(","));
                    associatedRole = this.getRole(roleName);
                    results.add(new GroupRole((IdentityType)agent, associatedGroup, associatedRole));
                }
            }
            return results;
        }
        catch (Exception e) {
            throw new IdentityManagementException((Throwable)e);
        }
        finally {
            try {
                search.close();
            }
            catch (NamingException e) {}
        }
    }

    public <T extends Relationship> int countQueryResults(RelationshipQuery<T> query) {
        return 0;
    }

    public void setAttribute(IdentityType identityType, Attribute<? extends Serializable> attribute) {
    }

    public <T extends Serializable> Attribute<T> getAttribute(IdentityType identityType, String attributeName) {
        return null;
    }

    public void removeAttribute(IdentityType identityType, String attributeName) {
    }

    public void validateCredentials(Credentials credentials) {
        CredentialHandler handler = this.getContext().getCredentialValidator(credentials.getClass(), (IdentityStore)this);
        if (handler == null) {
            throw new SecurityConfigurationException("No suitable CredentialHandler available for validating Credentials of type [" + credentials.getClass() + "] for IdentityStore [" + this.getClass() + "]");
        }
        handler.validate(credentials, (IdentityStore)this);
    }

    public void updateCredential(Agent agent, Object credential, Date effectiveDate, Date expiryDate) {
        CredentialHandler handler = this.getContext().getCredentialUpdater(credential.getClass(), (IdentityStore)this);
        if (handler == null) {
            throw new SecurityConfigurationException("No suitable CredentialHandler available for updating Credentials of type [" + credential.getClass() + "] for IdentityStore [" + this.getClass() + "]");
        }
        handler.update(agent, credential, (IdentityStore)this, effectiveDate, expiryDate);
    }

    private void addIdentityType(IdentityType newIdentityType, LDAPIdentityType ldapIdentityType) {
        ldapIdentityType.setId(newIdentityType.getId());
        ldapIdentityType.setEnabled(newIdentityType.isEnabled());
        ldapIdentityType.setCreatedDate(newIdentityType.getCreatedDate());
        ldapIdentityType.setExpirationDate(newIdentityType.getExpirationDate());
        this.getLDAPManager().createSubContext(ldapIdentityType.getDN(), ldapIdentityType.getLDAPAttributes());
        this.getLDAPManager().rebind(this.getCustomAttributesDN(ldapIdentityType.getDN()), ldapIdentityType.getCustomAttributes());
        this.populateLDAPOperationAttributes(ldapIdentityType);
        newIdentityType.setId(ldapIdentityType.getId());
    }

    private LDAPOperationManager getLDAPManager() {
        return this.getConfig().getLdapManager();
    }

    private String getCustomAttributesDN(String parentDN) {
        return "cn=custom-attributes," + parentDN;
    }

    private void updateIdentityType(IdentityType updatedIdentityType, LDAPIdentityType identityTypeEntry) {
        identityTypeEntry.setEnabled(updatedIdentityType.isEnabled());
        identityTypeEntry.setExpirationDate(updatedIdentityType.getExpirationDate());
        Attributes ldapAttributes = identityTypeEntry.getLDAPAttributes();
        NamingEnumeration<? extends javax.naming.directory.Attribute> all = ldapAttributes.getAll();
        Attributes clonedAttributes = (Attributes)identityTypeEntry.getLDAPAttributes().clone();
        while (all.hasMoreElements()) {
            javax.naming.directory.Attribute attribute = (javax.naming.directory.Attribute)all.nextElement();
            if (clonedAttributes.get(attribute.getID()) != null) {
                if (attribute.getID().equalsIgnoreCase("entryUUID") || attribute.getID().equalsIgnoreCase("createTimeStamp")) continue;
                this.getLDAPManager().modifyAttribute(identityTypeEntry.getDN(), attribute);
                continue;
            }
            this.getLDAPManager().addAttribute(identityTypeEntry.getDN(), attribute);
        }
        identityTypeEntry.getCustomAttributes().clear();
        Collection updatedAttributes = updatedIdentityType.getAttributes();
        for (Attribute attribute : updatedAttributes) {
            identityTypeEntry.getCustomAttributes().addAttribute(attribute.getName(), attribute.getValue());
        }
        this.getLDAPManager().rebind(this.getCustomAttributesDN(identityTypeEntry.getDN()), identityTypeEntry.getCustomAttributes());
    }

    private void populateIdentityType(LDAPIdentityType ldapIdentityType, IdentityType identityType) {
        identityType.setId(ldapIdentityType.getId());
        identityType.setEnabled(ldapIdentityType.isEnabled());
        identityType.setCreatedDate(ldapIdentityType.getCreatedDate());
        identityType.setExpirationDate(ldapIdentityType.getExpirationDate());
        identityType.setPartition(ldapIdentityType.getPartition());
        Set<Map.Entry<String, Serializable>> entrySet = ldapIdentityType.getCustomAttributes().getAttributes().entrySet();
        for (Map.Entry<String, Serializable> entry : entrySet) {
            if (entry.getKey().equals("enabled") || entry.getKey().equals("expiryDate")) continue;
            identityType.setAttribute(new Attribute(entry.getKey(), entry.getValue()));
        }
    }

    protected <T extends LDAPIdentityType> T lookupEntryById(Class<T> type, String id) {
        LDAPIdentityType identityType = null;
        NamingEnumeration<SearchResult> search = this.getLDAPManager().lookupById(this.getBaseDN(type), id);
        try {
            if (search.hasMore()) {
                SearchResult sr = search.next();
                identityType = (LDAPIdentityType)type.getConstructor(String.class).newInstance(this.getBaseDN(type));
                this.populateLDAPEntry(identityType, sr);
            }
            if (search.hasMore()) {
                throw new IdentityManagementException("Ambiguous entry found with the given id [" + id + "]");
            }
        }
        catch (NamingException e) {
            throw new IdentityManagementException("Error looking up entry.", (Throwable)e);
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error creating instance for type [" + type.getName() + "].", (Throwable)e);
        }
        finally {
            if (search != null) {
                try {
                    search.close();
                }
                catch (NamingException e) {}
            }
        }
        if (identityType == null) {
            throw new IdentityManagementException("No entry found for the given type [" + type.getName() + "] and id [" + id + "]");
        }
        return (T)identityType;
    }

    private <T extends LDAPIdentityType> T populateIdentityTypeEntry(T identityType) {
        String filter = "(&(objectClass=*)(" + identityType.getBidingName() + "))";
        NamingEnumeration<SearchResult> search = this.getLDAPManager().search(identityType.getDnSuffix(), filter);
        try {
            if (search.hasMore()) {
                SearchResult sr = search.next();
                this.populateLDAPEntry(identityType, sr);
            } else {
                identityType = null;
            }
        }
        catch (NamingException e) {
            throw new IdentityManagementException("Error looking up entry.", (Throwable)e);
        }
        finally {
            if (search != null) {
                try {
                    search.close();
                }
                catch (NamingException e) {}
            }
        }
        return identityType;
    }

    private <T extends LDAPIdentityType> void populateLDAPEntry(T identityType, SearchResult sr) throws NamingException {
        identityType.setLDAPAttributes(sr.getAttributes());
        identityType.setCustomAttributes(this.getCustomAttributes(identityType));
        this.populateLDAPOperationAttributes(identityType);
        identityType.setPartition((Partition)new Realm("default"));
        identityType.setCustomAttributes(this.getCustomAttributes(identityType));
    }

    private <T extends LDAPIdentityType> void populateLDAPOperationAttributes(T identityType) {
        try {
            Attributes operationalAttributes = this.getLDAPManager().lookupOperationalAttributes(identityType.getDnSuffix(), identityType.getBidingName());
            identityType.setId(operationalAttributes.get("entryUUID").get().toString());
            String createdTimeStamp = operationalAttributes.get("createTimeStamp").get().toString();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                identityType.setCreatedDate(sdf.parse(createdTimeStamp));
            }
            catch (ParseException e) {
                throw new IdentityManagementException("Error parsing created date.", (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error populating operational attributes.", (Throwable)e);
        }
    }

    private LDAPCustomAttributes getCustomAttributes(LDAPAttributedType attributedType) {
        String customDN = this.getCustomAttributesDN(attributedType.getDN());
        LDAPCustomAttributes customAttributes = null;
        try {
            customAttributes = (LDAPCustomAttributes)this.getLDAPManager().lookup(customDN);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (customAttributes == null) {
            this.getLDAPManager().bind(customDN, attributedType.getCustomAttributes());
        }
        return customAttributes;
    }

    private Group getParentGroup(LDAPGroup childGroup) {
        BasicAttributes matchAttrs = new BasicAttributes(true);
        String dnSuffix = childGroup.getDnSuffix();
        matchAttrs.put(new BasicAttribute("member", "cn=" + childGroup.getName() + "," + dnSuffix));
        NamingEnumeration<SearchResult> answer = null;
        try {
            answer = this.getLDAPManager().search(dnSuffix, matchAttrs, new String[]{"cn"});
            if (answer.hasMoreElements()) {
                SearchResult sr = (SearchResult)answer.nextElement();
                Attributes attributes = sr.getAttributes();
                String cn = (String)attributes.get("cn").get();
                String nameInNamespace = sr.getNameInNamespace();
                String str = "cn=" + cn + ",";
                String substring = nameInNamespace.substring(nameInNamespace.indexOf(str) + str.length());
                Group group = this.getGroup(cn, substring);
                return group;
            }
        }
        catch (NamingException e) {
            throw new RuntimeException("Error looking parent group for [" + childGroup.getDN() + "]", e);
        }
        finally {
            if (answer != null) {
                try {
                    answer.close();
                }
                catch (NamingException e) {}
            }
        }
        return null;
    }

    private void addGroup(Group newGroup) {
        if (newGroup.getName() == null) {
            throw new IdentityManagementException("No name was provided.");
        }
        if (this.getGroup(newGroup.getPath()) != null) {
            throw new IdentityManagementException("Group already exists with the given name [" + newGroup.getName() + "] for the given Partition [" + this.getContext().getPartition().getName() + "]");
        }
        LDAPGroup ldapGroup = new LDAPGroup(this.getGroupBaseDN(newGroup.getPath()));
        ldapGroup.setName(newGroup.getName());
        this.addIdentityType((IdentityType)newGroup, ldapGroup);
        if (newGroup.getParentGroup() != null) {
            LDAPGroup parentGroup = this.lookupGroup(newGroup.getParentGroup().getPath());
            if (parentGroup == null) {
                throw new RuntimeException("Parent group [" + newGroup.getParentGroup() + "] does not exists.");
            }
            parentGroup.addChildGroup(ldapGroup);
            ldapGroup.setParentGroup(parentGroup);
            this.getLDAPManager().modifyAttribute(parentGroup.getDN(), parentGroup.getLDAPAttributes().get("member"));
        }
    }

    private String getGroupBaseDN(String groupPath) {
        String groupMappingDN;
        if (!groupPath.startsWith("/")) {
            groupPath = "/" + groupPath;
        }
        if ((groupMappingDN = this.getConfig().getGroupMappingDN(groupPath)) == null) {
            groupMappingDN = this.getConfig().getGroupDNSuffix();
        }
        return groupMappingDN;
    }

    private void addRole(Role newRole) {
        if (newRole.getName() == null) {
            throw new IdentityManagementException("No name was provided.");
        }
        if (this.getRole(newRole.getName()) != null) {
            throw new IdentityManagementException("Role already exists with the given name [" + newRole.getName() + "] for the given Partition [" + this.getContext().getPartition().getName() + "]");
        }
        LDAPRole ldapRole = new LDAPRole(this.getConfig().getRoleDNSuffix());
        ldapRole.setName(newRole.getName());
        this.addIdentityType((IdentityType)newRole, ldapRole);
    }

    private void addAgent(Agent newAgent) {
        LDAPAgent ldapAgent = new LDAPAgent(this.getConfig().getAgentDNSuffix());
        ldapAgent.setLoginName(newAgent.getLoginName());
        this.addIdentityType((IdentityType)newAgent, ldapAgent);
    }

    private void addUser(User newUser) {
        LDAPUser ldapUser = new LDAPUser(this.getConfig().getUserDNSuffix());
        ldapUser.setLoginName(newUser.getLoginName());
        ldapUser.setFirstName(newUser.getFirstName());
        ldapUser.setLastName(newUser.getLastName());
        ldapUser.setFullName(ldapUser.getUserCN());
        ldapUser.setEmail(newUser.getEmail());
        this.addIdentityType((IdentityType)newUser, ldapUser);
    }

    private void updateGroup(Group updatedGroup) {
        LDAPGroup groupEntry = (LDAPGroup)this.lookupEntry(updatedGroup);
        this.updateIdentityType((IdentityType)updatedGroup, groupEntry);
    }

    private void updateRole(Role updatedRole) {
        LDAPRole roleEntry = (LDAPRole)this.lookupEntry(updatedRole);
        this.updateIdentityType((IdentityType)updatedRole, roleEntry);
    }

    private void updateAgent(Agent updatedAgent) {
        LDAPAgent agentEntry = (LDAPAgent)this.lookupEntry(updatedAgent);
        this.updateIdentityType((IdentityType)updatedAgent, agentEntry);
    }

    private void updateUser(User updatedUser) {
        LDAPUser userEntry = (LDAPUser)this.lookupEntry(updatedUser);
        userEntry.setFirstName(updatedUser.getFirstName());
        userEntry.setLastName(updatedUser.getLastName());
        userEntry.setFullName(userEntry.getUserCN());
        userEntry.setEmail(updatedUser.getEmail());
        this.updateIdentityType((IdentityType)updatedUser, userEntry);
    }

    private String getBaseDN(Class<? extends IdentityType> identityTypeClass) {
        String baseDN = null;
        baseDN = IDMUtil.isUserType(identityTypeClass) ? this.getConfig().getUserDNSuffix() : (IDMUtil.isRoleType(identityTypeClass) ? this.getConfig().getRoleDNSuffix() : (IDMUtil.isGroupType(identityTypeClass) ? this.getConfig().getGroupDNSuffix() : (IDMUtil.isAgentType(identityTypeClass) ? this.getConfig().getAgentDNSuffix() : this.getConfig().getBaseDN())));
        return baseDN;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addGroupRoleRelationship(GroupRole groupRole) {
        Group group = groupRole.getGroup();
        if (group == null) {
            throw new IdentityManagementException("You must specify a group for this relationship type.");
        }
        Role role = groupRole.getRole();
        if (role == null) {
            throw new IdentityManagementException("You must specify a role for this relationship type.");
        }
        IdentityType member = groupRole.getMember();
        if (!Agent.class.isInstance(member)) throw new IdentityManagementException("You must assign a valid Agent instance for this relationship type.");
        Agent agent = (Agent)member;
        if (agent == null) {
            throw new IdentityManagementException("You must assign a agent for this relationship type.");
        }
        LDAPAgent agentEntry = (LDAPAgent)this.lookupEntry(agent);
        LDAPGroup groupEntry = (LDAPGroup)this.lookupEntry(group);
        LDAPRole roleEntry = (LDAPRole)this.lookupEntry(role);
        LDAPGroupRole groupRoleEntry = new LDAPGroupRole(agentEntry, groupEntry, roleEntry);
        NamingEnumeration<SearchResult> search = this.getLDAPManager().search(agentEntry.getDN(), groupRoleEntry.getBidingName());
        try {
            if (!search.hasMore()) {
                this.getLDAPManager().createSubContext(groupRoleEntry.getDN(), groupRoleEntry.getLDAPAttributes());
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error creating GroupRole relationship.", (Throwable)e);
        }
        finally {
            if (search != null) {
                try {
                    search.close();
                }
                catch (NamingException e) {}
            }
        }
        this.addMember(groupRoleEntry, roleEntry);
        this.addGrantRelationship(new Grant((IdentityType)agent, role));
        this.addGroupMembership(new GroupMembership((IdentityType)agent, group));
    }

    private void addGroupMembership(GroupMembership groupMembership) {
        Group group = groupMembership.getGroup();
        if (group == null) {
            throw new IdentityManagementException("You must specify a group for this relationship type.");
        }
        LDAPGroup groupEntry = (LDAPGroup)this.lookupEntry(group);
        IdentityType member = groupMembership.getMember();
        if (!Agent.class.isInstance(member)) {
            throw new IdentityManagementException("Only Agent types are supported for this relationship type.");
        }
        LDAPAgent agentEntry = (LDAPAgent)this.lookupEntry(member);
        this.addMember(groupEntry, agentEntry);
    }

    private void addGrantRelationship(Grant grant) {
        Agent agent;
        Role role = grant.getRole();
        if (role == null) {
            throw new IdentityManagementException("You must assign a role for this relationship type.");
        }
        LDAPRole roleEntry = (LDAPRole)this.lookupEntry(role);
        if (Agent.class.isInstance(grant.getAssignee())) {
            agent = (Agent)grant.getAssignee();
            if (agent == null) {
                throw new IdentityManagementException("You must assign a agent for this relationship type.");
            }
        } else {
            throw new IdentityManagementException("You must assign a valid Agent instance for this relationship type.");
        }
        LDAPAgent agentEntry = (LDAPAgent)this.lookupEntry(agent);
        this.addMember(roleEntry, agentEntry);
    }

    private void addMember(LDAPEntry parentEntry, LDAPEntry childEntry) {
        parentEntry.addMember(childEntry);
        this.getLDAPManager().modifyAttribute(parentEntry.getDN(), parentEntry.getLDAPAttributes().get("member"));
    }

    private <T extends IdentityType> T lookupEntry(T identityType) {
        LDAPIdentityType identityTypeEntry = null;
        if (Agent.class.isInstance(identityType)) {
            Agent agent = (Agent)identityType;
            identityTypeEntry = User.class.isInstance(agent) ? this.lookupEntryById(LDAPUser.class, agent.getId()) : this.lookupEntryById(LDAPAgent.class, agent.getId());
        } else if (Role.class.isInstance(identityType)) {
            identityTypeEntry = this.lookupEntryById(LDAPRole.class, identityType.getId());
        } else if (Group.class.isInstance(identityType)) {
            identityTypeEntry = this.lookupEntryById(LDAPGroup.class, identityType.getId());
        } else {
            throw new IdentityManagementException("Unsupported type [" + identityType.getClass().getName() + "].");
        }
        return (T)identityTypeEntry;
    }

    private String getIdAttribute(Class<? extends IdentityType> identityTypeClass) {
        String idAttribute = null;
        if (IDMUtil.isAgentType(identityTypeClass)) {
            idAttribute = "uid";
        } else if (IDMUtil.isRoleType(identityTypeClass)) {
            idAttribute = "cn";
        } else if (IDMUtil.isGroupType(identityTypeClass)) {
            idAttribute = "cn";
        }
        return idAttribute;
    }

    private IdentityManagementException createUnsupportedIdentityTypeException(Class<? extends IdentityType> identityTypeClass) {
        return new IdentityManagementException("Unsupported IdentityType [" + identityTypeClass.getName() + "].");
    }

    private IdentityManagementException createUnsupportedAttributedType(Class<? extends AttributedType> type) {
        return new IdentityManagementException("Unsupported AttributedType [" + type.getName() + "].");
    }

    private IdentityManagementException createUnsupportedRelationshipType(Class<? extends Relationship> type) {
        return new IdentityManagementException("Unsupported Relationship type [" + type.getName() + "].");
    }

    protected LDAPRole lookupRole(String name) {
        return this.populateIdentityTypeEntry(new LDAPRole(name, this.getConfig().getRoleDNSuffix()));
    }

    protected LDAPAgent lookupAgent(String loginName) {
        LDAPAgent agent = this.populateIdentityTypeEntry(new LDAPAgent(loginName, this.getConfig().getAgentDNSuffix()));
        if (agent == null) {
            agent = this.lookupUser(loginName);
        }
        return agent;
    }

    protected LDAPAgent lookupAgent(Agent agent) {
        LDAPAgent storedAgent = null;
        storedAgent = User.class.isInstance(agent) ? this.lookupUser(agent.getLoginName()) : this.lookupAgent(agent.getLoginName());
        return storedAgent;
    }

    protected LDAPGroup lookupGroup(String groupPath) {
        return this.lookupGroup(groupPath, this.getGroupBaseDN(groupPath));
    }

    protected LDAPGroup lookupGroup(String groupPath, String baseDN) {
        String name = null;
        if (!groupPath.startsWith("/")) {
            groupPath = "/" + groupPath;
        }
        String[] groupPaths = groupPath.split("/");
        name = groupPaths[groupPaths.length - 1];
        LDAPGroup ldapGroup = new LDAPGroup(name, baseDN);
        ldapGroup.setPath(groupPath);
        return this.populateIdentityTypeEntry(ldapGroup);
    }

    private LDAPUser lookupUser(String loginName) {
        return this.populateIdentityTypeEntry(new LDAPUser(loginName, this.getConfig().getUserDNSuffix()));
    }

    private void removeGroupRoleRelationship(GroupMembership groupMembership, GroupRole groupRole) {
        LDAPGroup groupEntry = this.lookupGroup(groupRole.getGroup().getPath());
        LDAPAgent agentEntry = null;
        if (Agent.class.isInstance(groupMembership.getMember())) {
            Agent agent = (Agent)groupMembership.getMember();
            agentEntry = this.lookupAgent(agent);
        }
        NamingEnumeration<SearchResult> search = this.lookupGroupRoleEntry(agentEntry, groupEntry);
        try {
            if (search.hasMore()) {
                this.getLDAPManager().destroySubcontext(search.next().getNameInNamespace());
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error removing GroupRole relationship.", (Throwable)e);
        }
    }

    private void removeGroupMembership(GroupMembership groupMembership) {
        LDAPGroup groupEntry = this.lookupGroup(groupMembership.getGroup().getPath());
        LDAPAgent agentEntry = null;
        if (Agent.class.isInstance(groupMembership.getMember())) {
            Agent agent = (Agent)groupMembership.getMember();
            agentEntry = this.lookupAgent(agent);
        }
        this.removeMember(groupEntry, agentEntry);
    }

    private void removeGrantRelationship(Grant grant) {
        LDAPRole roleEntry = this.lookupRole(grant.getRole().getName());
        LDAPAgent agentEntry = null;
        if (Agent.class.isInstance(grant.getAssignee())) {
            Agent agent = (Agent)grant.getAssignee();
            agentEntry = this.lookupAgent(agent);
        }
        this.removeMember(roleEntry, agentEntry);
    }

    private NamingEnumeration<SearchResult> lookupGroupRoleEntry(LDAPAgent agentEntry, LDAPGroup groupEntry) {
        return this.getLDAPManager().search(agentEntry.getDN(), groupEntry.getBidingName());
    }

    private void removeAgentRelationships(Agent agent) {
        DefaultRelationshipQuery<Grant> query = new DefaultRelationshipQuery<Grant>(Grant.class, this);
        query.setParameter((QueryParameter)Grant.ASSIGNEE, agent);
        List<Grant> resultList = query.getResultList();
        for (Grant grant : resultList) {
            this.remove((AttributedType)grant);
        }
        DefaultRelationshipQuery<GroupMembership> groupQuery = new DefaultRelationshipQuery<GroupMembership>(GroupMembership.class, this);
        groupQuery.setParameter((QueryParameter)GroupMembership.MEMBER, agent);
        List<GroupMembership> resultGroups = groupQuery.getResultList();
        for (GroupMembership groups : resultGroups) {
            this.remove((AttributedType)groups);
        }
        DefaultRelationshipQuery<GroupRole> groupRoleQuery = new DefaultRelationshipQuery<GroupRole>(GroupRole.class, this);
        groupRoleQuery.setParameter((QueryParameter)GroupRole.MEMBER, agent);
        List<GroupRole> resultGroupRoless = groupRoleQuery.getResultList();
        for (GroupRole groupRoles : resultGroupRoless) {
            this.remove((AttributedType)groupRoles);
        }
    }

    private void removeMember(LDAPEntry parentEntry, LDAPEntry childEntry) {
        parentEntry.removeMember(childEntry);
        this.getLDAPManager().modifyAttribute(parentEntry.getDN(), parentEntry.getLDAPAttributes().get("member"));
    }
}

