/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.ldap.internal.LDAPIdentityStoreConfiguration;

public class LDAPOperationManager {
    private List<String> managedAttributes = new ArrayList<String>();
    private LdapContext context;
    private DirContext authenticationContext;
    private LDAPIdentityStoreConfiguration config;

    public LDAPOperationManager(LDAPIdentityStoreConfiguration config) throws NamingException {
        this.config = config;
        this.context = this.constructContext();
        this.authenticationContext = this.constructContext();
    }

    private LdapContext constructContext() {
        String url;
        Properties env = new Properties();
        env.setProperty("java.naming.factory.initial", this.config.getFactoryName());
        env.setProperty("java.naming.security.authentication", this.config.getAuthType());
        String protocol = this.config.getProtocol();
        if (protocol != null) {
            env.setProperty("java.naming.security.protocol", protocol);
        }
        String bindDN = this.config.getBindDN();
        char[] bindCredential = null;
        if (this.config.getBindCredential() != null) {
            bindCredential = this.config.getBindCredential().toCharArray();
        }
        if (bindDN != null) {
            env.setProperty("java.naming.security.principal", bindDN);
            env.put("java.naming.security.credentials", bindCredential);
        }
        if ((url = this.config.getLdapURL()) == null) {
            throw new RuntimeException("url");
        }
        env.setProperty("java.naming.provider.url", url);
        Properties additionalProperties = this.config.getAdditionalProperties();
        Set<Object> keys = additionalProperties.keySet();
        for (Object key : keys) {
            env.setProperty((String)key, additionalProperties.getProperty((String)key));
        }
        InitialLdapContext context = null;
        try {
            context = new InitialLdapContext(env, null);
        }
        catch (NamingException e) {
            throw new IdentityManagementException("Error creating LDAP context.", (Throwable)e);
        }
        return context;
    }

    public void bind(String dn, Object object) {
        try {
            this.context.bind(dn, object);
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                try {
                    this.context.close();
                    this.context = this.constructContext();
                    this.context.bind(dn, object);
                }
                catch (NamingException e1) {
                    throw new RuntimeException(e1);
                }
            }
            throw new RuntimeException(e);
        }
    }

    public void modifyAttribute(String dn, Attribute attribute) {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, attribute)};
        this.modifyAttributes(dn, mods);
    }

    public void removeAttribute(String dn, Attribute attribute) {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, attribute)};
        this.modifyAttributes(dn, mods);
    }

    public void addAttribute(String dn, Attribute attribute) {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(1, attribute)};
        this.modifyAttributes(dn, mods);
    }

    public void rebind(String dn, Object object) {
        try {
            this.context.rebind(dn, object);
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                try {
                    this.context.close();
                    this.context = this.constructContext();
                    this.context.rebind(dn, object);
                }
                catch (NamingException e1) {
                    throw new RuntimeException(e1);
                }
            }
            throw new RuntimeException(e);
        }
    }

    public <T> T lookup(String dn) {
        try {
            return (T)this.context.lookup(dn);
        }
        catch (NamingException e) {
            return null;
        }
    }

    public <T> List<T> removeEntryById(String baseDN, String id) {
        ArrayList result = new ArrayList();
        NamingEnumeration<SearchResult> answer = null;
        try {
            BasicAttributes attributesToSearch = new BasicAttributes(true);
            attributesToSearch.put(new BasicAttribute("entryUUID", id));
            answer = this.getContext().search(baseDN, (Attributes)attributesToSearch);
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                this.destroySubcontext(sr.getNameInNamespace());
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (answer != null) {
                try {
                    answer.close();
                }
                catch (NamingException e) {}
            }
        }
        return result;
    }

    public Attributes lookupOperationalAttributes(String baseDN, String entryDN) {
        NamingEnumeration<SearchResult> answer = null;
        try {
            SearchControls controls = new SearchControls();
            controls.setReturningAttributes(new String[]{"entryUUID", "createTimeStamp"});
            answer = this.getContext().search(baseDN, entryDN, controls);
            if (answer.hasMore()) {
                Attributes attributes = answer.next().getAttributes();
                return attributes;
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (answer != null) {
                try {
                    answer.close();
                }
                catch (NamingException e) {}
            }
        }
        return null;
    }

    public NamingEnumeration<SearchResult> search(String baseDN, Attributes attributesToSearch, String[] attributesToReturn) {
        try {
            return this.context.search(baseDN, attributesToSearch, attributesToReturn);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public NamingEnumeration<SearchResult> search(String baseDN, String filter, String[] attributesToReturn, SearchControls searchControls) {
        try {
            return this.getContext().search(baseDN, filter, (Object[])attributesToReturn, searchControls);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public NamingEnumeration<SearchResult> search(String baseDN, String filter) {
        try {
            SearchControls cons = new SearchControls();
            cons.setSearchScope(2);
            cons.setReturningObjFlag(true);
            return this.getContext().search(baseDN, filter, cons);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public NamingEnumeration<SearchResult> lookupById(String baseDN, String id) {
        try {
            String filter = "(&(objectClass=*)(entryUUID=" + id + "))";
            return this.getContext().search(baseDN, filter, new SearchControls());
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public void destroySubcontext(String dn) {
        try {
            this.destroyRecursively(dn);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void destroyRecursively(String dn) {
        NamingEnumeration<Binding> enumeration = null;
        try {
            enumeration = this.getContext().listBindings(dn);
            while (enumeration.hasMore()) {
                Binding binding = enumeration.next();
                String name = binding.getNameInNamespace();
                this.destroyRecursively(name);
            }
            this.getContext().unbind(dn);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                enumeration.close();
            }
            catch (Exception e) {}
        }
    }

    public boolean isManagedAttribute(String attributeName) {
        if (this.managedAttributes.contains(attributeName)) {
            return true;
        }
        if (this.checkAttributePresence(attributeName)) {
            this.managedAttributes.add(attributeName);
            return true;
        }
        return false;
    }

    public boolean checkAttributePresence(String attributeName) {
        try {
            DirContext schema = this.context.getSchema("");
            DirContext cnSchema = (DirContext)schema.lookup("AttributeDefinition/" + attributeName);
            if (cnSchema != null) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public boolean authenticate(String dn, String password) {
        try {
            this.authenticationContext.addToEnvironment("java.naming.security.principal", dn);
            this.authenticationContext.addToEnvironment("java.naming.security.credentials", password);
            this.authenticationContext.lookup(dn);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void modifyAttributes(String dn, ModificationItem[] mods) {
        try {
            this.context.modifyAttributes(dn, mods);
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                try {
                    this.context.close();
                    this.context = this.constructContext();
                    this.context.modifyAttributes(dn, mods);
                }
                catch (NamingException e1) {
                    throw new RuntimeException(e1);
                }
            }
            throw new RuntimeException(e);
        }
    }

    public void createSubContext(String name, Attributes attributes) {
        try {
            this.getContext().createSubcontext(name, attributes);
        }
        catch (NamingException e) {
            throw new RuntimeException("Error creating subcontext [" + name + "]", e);
        }
    }

    private LdapContext getContext() {
        return this.context;
    }
}

