/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.social.auth;

import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import javax.servlet.http.HttpSession;
import org.picketlink.authentication.Authenticator;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.basic.User;
import org.picketlink.social.auth.AbstractSocialAuthenticator;
import org.picketlink.social.auth.conf.FacebookConfiguration;
import org.picketlink.social.standalone.fb.FacebookProcessor;

public class FacebookAuthenticator
extends AbstractSocialAuthenticator {
    protected FacebookConfiguration configuration;
    protected static final String FB_AUTH_STATE_SESSION_ATTRIBUTE = "FB_AUTH_STATE_SESSION_ATTRIBUTE";
    protected String returnURL;
    protected String clientID;
    protected String clientSecret;
    protected String scope;
    protected FacebookProcessor processor;

    public void setConfiguration(FacebookConfiguration configuration) {
        this.configuration = configuration;
    }

    public void authenticate() {
        if (this.httpServletRequest == null) {
            throw new IllegalStateException("http request not available");
        }
        if (this.httpServletResponse == null) {
            throw new IllegalStateException("http response not available");
        }
        if (this.configuration == null) {
            throw new IllegalStateException("configuration not available");
        }
        HttpSession session = this.httpServletRequest.getSession();
        Principal principal = null;
        if (this.isFirstInteraction(session)) {
            try {
                this.getFacebookProcessor().initialInteraction(this.httpServletRequest, this.httpServletResponse);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while initiating Facebook authentication interaction.", e);
            }
        } else if (this.isAuthenticationInteraction(session)) {
            if (!this.httpServletResponse.isCommitted()) {
                this.getFacebookProcessor().handleAuthStage(this.httpServletRequest, this.httpServletResponse);
            }
        } else if (this.isAuthorizationInteraction(session)) {
            session.removeAttribute(FB_AUTH_STATE_SESSION_ATTRIBUTE);
            principal = this.getFacebookProcessor().getPrincipal(this.httpServletRequest, this.httpServletResponse);
        }
        if (principal != null) {
            this.setStatus(Authenticator.AuthenticationStatus.SUCCESS);
            this.setAccount((Account)new User(principal.getName()));
        }
    }

    private boolean isAuthorizationInteraction(HttpSession session) {
        return this.getCurrentAuthenticationState(session).equals(STATES.AUTHZ.name());
    }

    private boolean isAuthenticationInteraction(HttpSession session) {
        return this.getCurrentAuthenticationState(session).equals(STATES.AUTH.name());
    }

    private boolean isFirstInteraction(HttpSession session) {
        return this.getCurrentAuthenticationState(session) == null || this.getCurrentAuthenticationState(session).isEmpty();
    }

    private String getCurrentAuthenticationState(HttpSession session) {
        return (String)session.getAttribute(FB_AUTH_STATE_SESSION_ATTRIBUTE);
    }

    private FacebookProcessor getFacebookProcessor() {
        if (this.processor == null) {
            if (this.clientID == null) {
                this.clientID = this.configuration.getClientID();
            }
            if (this.clientSecret == null) {
                this.clientSecret = this.configuration.getClientSecret();
            }
            if (this.scope == null) {
                this.scope = this.configuration.getScope();
            }
            if (this.returnURL == null) {
                this.returnURL = this.configuration.getReturnURL();
            }
            this.processor = new FacebookProcessor(this.clientID, this.clientSecret, this.scope, this.returnURL, Collections.EMPTY_LIST);
        }
        return this.processor;
    }

    private static enum STATES {
        AUTH,
        AUTHZ,
        FINISH;

    }
}

