/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.social.standalone.oauth;

import java.io.IOException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.picketlink.social.standalone.oauth.OpenIDAliasMapper;
import org.picketlink.social.standalone.oauth.OpenIdPrincipal;
import org.picketlink.social.standalone.oauth.StringUtil;

public class OpenIDProcessor {
    public static final String AUTH_TYPE = "authType";
    private ConsumerManager openIdConsumerManager;
    private FetchRequest fetchRequest;
    private String openIdServiceUrl = null;
    private String returnURL = null;
    private String requiredAttributes;
    private String optionalAttributes = null;
    private boolean initialized = false;
    protected List<String> roles = new ArrayList<String>();
    public static ThreadLocal<Principal> cachedPrincipal = new ThreadLocal();
    public static ThreadLocal<List<String>> cachedRoles = new ThreadLocal();
    public static String EMPTY_PASSWORD = "EMPTY";

    public OpenIDProcessor(String theReturnURL, String requiredAttributes, String optionalAttributes) {
        this.returnURL = theReturnURL;
        this.requiredAttributes = requiredAttributes;
        this.optionalAttributes = optionalAttributes;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize(List<String> requiredRoles) throws MessageException, ConsumerException {
        List<String> tokens;
        if (this.openIdConsumerManager == null) {
            this.openIdConsumerManager = new ConsumerManager();
        }
        this.fetchRequest = FetchRequest.createFetchRequest();
        if (StringUtil.isNotNull(this.requiredAttributes)) {
            tokens = StringUtil.tokenize(this.requiredAttributes);
            for (String token : tokens) {
                this.fetchRequest.addAttribute(token, OpenIDAliasMapper.get(token), true);
            }
        }
        if (StringUtil.isNotNull(this.optionalAttributes)) {
            tokens = StringUtil.tokenize(this.optionalAttributes);
            for (String token : tokens) {
                String type = OpenIDAliasMapper.get(token);
                if (type == null) {
                    System.out.println("Null Type returned for " + token);
                }
                this.fetchRequest.addAttribute(token, type, false);
            }
        }
        this.roles.addAll(requiredRoles);
        this.initialized = true;
    }

    public boolean prepareAndSendAuthRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String authType = request.getParameter(AUTH_TYPE);
        if (authType == null || authType.length() == 0) {
            authType = (String)request.getSession().getAttribute(AUTH_TYPE);
        }
        this.determineServiceUrl(authType);
        String openId = this.openIdServiceUrl;
        HttpSession session = request.getSession(true);
        if (openId != null) {
            List discoveries;
            session.setAttribute("openid", (Object)openId);
            try {
                discoveries = this.openIdConsumerManager.discover(openId);
            }
            catch (DiscoveryException e) {
                throw new RuntimeException(e);
            }
            DiscoveryInformation discovered = this.openIdConsumerManager.associate(discoveries);
            session.setAttribute("discovery", (Object)discovered);
            try {
                AuthRequest authReq = this.openIdConsumerManager.authenticate(discovered, this.returnURL);
                authReq.addExtension((MessageExtension)this.fetchRequest);
                String url = authReq.getDestinationUrl(true);
                response.sendRedirect(url);
                request.getSession().setAttribute("STATE", (Object)STATES.AUTH.name());
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public Principal processIncomingAuthResult(HttpServletRequest request, HttpServletResponse response) throws IOException {
        VerificationResult verification;
        OpenIdPrincipal openIDPrincipal = null;
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new RuntimeException("wrong lifecycle: session was null");
        }
        ParameterList responseParamList = new ParameterList(request.getParameterMap());
        DiscoveryInformation discovered = (DiscoveryInformation)session.getAttribute("discovery");
        if (discovered == null) {
            throw new RuntimeException("discovered information was null");
        }
        StringBuffer receivingURL = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString != null && queryString.length() > 0) {
            receivingURL.append("?").append(request.getQueryString());
        }
        try {
            verification = this.openIdConsumerManager.verify(receivingURL.toString(), responseParamList, discovered);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Identifier identifier = verification.getVerifiedId();
        if (identifier != null) {
            AuthSuccess authSuccess = (AuthSuccess)verification.getAuthResponse();
            Map attributes = null;
            if (authSuccess.hasExtension("http://openid.net/srv/ax/1.0")) {
                FetchResponse fetchResp;
                try {
                    fetchResp = (FetchResponse)authSuccess.getExtension("http://openid.net/srv/ax/1.0");
                }
                catch (MessageException e) {
                    throw new RuntimeException(e);
                }
                attributes = fetchResp.getAttributes();
            }
            openIDPrincipal = this.createPrincipal(identifier.getIdentifier(), discovered.getOPEndpoint(), attributes);
            request.getSession().setAttribute("PRINCIPAL", (Object)openIDPrincipal);
        } else {
            response.sendError(403);
        }
        return openIDPrincipal;
    }

    private OpenIdPrincipal createPrincipal(String identifier, URL openIdProvider, Map<String, List<String>> attributes) {
        return new OpenIdPrincipal(identifier, openIdProvider, attributes);
    }

    private void determineServiceUrl(String service) {
        this.openIdServiceUrl = Providers.GOOGLE.get();
        if (StringUtil.isNotNull(service)) {
            if ("google".equals(service)) {
                this.openIdServiceUrl = Providers.GOOGLE.get();
            } else if ("yahoo".equals(service)) {
                this.openIdServiceUrl = Providers.YAHOO.get();
            } else if ("myspace".equals(service)) {
                this.openIdServiceUrl = Providers.MYSPACE.get();
            } else if ("myopenid".equals(service)) {
                this.openIdServiceUrl = Providers.MYOPENID.get();
            }
        }
    }

    private static enum Providers {
        GOOGLE("https://www.google.com/accounts/o8/id"),
        YAHOO("https://me.yahoo.com/"),
        MYSPACE("myspace.com"),
        MYOPENID("https://myopenid.com/");

        private String name;

        private Providers(String name) {
            this.name = name;
        }

        String get() {
            return this.name;
        }
    }

    private static enum STATES {
        AUTH,
        AUTHZ,
        FINISH;

    }
}

