/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.script;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.picocontainer.script.UnsupportedScriptTypeException;

public class ScriptedBuilderNameResolver {
    public static final String GROOVY = ".groovy";
    public static final String BEANSHELL = ".bsh";
    public static final String JAVASCRIPT = ".js";
    public static final String JYTHON = ".py";
    public static final String XML = ".xml";
    public static final String DEFAULT_GROOVY_BUILDER = "org.picocontainer.script.groovy.GroovyContainerBuilder";
    public static final String DEFAULT_BEANSHELL_BUILDER = "org.picocontainer.script.bsh.BeanShellContainerBuilder";
    public static final String DEFAULT_JAVASCRIPT_BUILDER = "org.picocontainer.script.rhino.JavascriptContainerBuilder";
    public static final String DEFAULT_XML_BUILDER = "org.picocontainer.script.xml.XMLContainerBuilder";
    public static final String DEFAULT_JYTHON_BUILDER = "org.picocontainer.script.jython.JythonContainerBuilder";
    private final Map<String, String> extensionToBuilders = new HashMap<String, String>();

    public ScriptedBuilderNameResolver() {
        this.resetBuilders();
    }

    public String getBuilderClassName(File compositionFile) {
        String language = this.getExtension(compositionFile.getAbsolutePath());
        return this.getBuilderClassName(language);
    }

    public String getBuilderClassName(URL compositionURL) {
        String language = this.getExtension(compositionURL.getFile());
        return this.getBuilderClassName(language);
    }

    public synchronized String getBuilderClassName(String extension) throws UnsupportedScriptTypeException {
        String resultingBuilderClassName = this.extensionToBuilders.get(extension);
        if (resultingBuilderClassName == null) {
            throw new UnsupportedScriptTypeException(extension, this.getAllSupportedExtensions());
        }
        return resultingBuilderClassName;
    }

    public synchronized void resetBuilders() {
        this.extensionToBuilders.clear();
        this.registerBuilder(GROOVY, DEFAULT_GROOVY_BUILDER);
        this.registerBuilder(BEANSHELL, DEFAULT_BEANSHELL_BUILDER);
        this.registerBuilder(JAVASCRIPT, DEFAULT_JAVASCRIPT_BUILDER);
        this.registerBuilder(XML, DEFAULT_XML_BUILDER);
        this.registerBuilder(JYTHON, DEFAULT_JYTHON_BUILDER);
    }

    public synchronized void registerBuilder(String extension, String className) {
        this.extensionToBuilders.put(extension, className);
    }

    public synchronized String[] getAllSupportedExtensions() {
        return this.extensionToBuilders.keySet().toArray(new String[this.extensionToBuilders.size()]);
    }

    private String getExtension(String fileName) {
        return fileName.substring(fileName.lastIndexOf("."));
    }
}

