/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.script;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.classname.ClassName;
import org.picocontainer.classname.DefaultClassLoadingPicoContainer;
import org.picocontainer.script.ScriptedBuilderNameResolver;
import org.picocontainer.script.ScriptedContainerBuilder;
import org.picocontainer.script.UnsupportedScriptTypeException;

public class ScriptedContainerBuilderFactory {
    private ScriptedContainerBuilder containerBuilder;

    public ScriptedContainerBuilderFactory(File compositionFile, ClassLoader classLoader, ScriptedBuilderNameResolver scriptedBuilderResolver) throws UnsupportedScriptTypeException, FileNotFoundException {
        this(new FileReader(ScriptedContainerBuilderFactory.fileExists(compositionFile)), scriptedBuilderResolver.getBuilderClassName(compositionFile), classLoader);
    }

    public ScriptedContainerBuilderFactory(File compositionFile, ClassLoader classLoader) throws IOException {
        this(compositionFile, classLoader, new ScriptedBuilderNameResolver());
    }

    public ScriptedContainerBuilderFactory(File compositionFile) throws IOException {
        this(compositionFile, Thread.currentThread().getContextClassLoader());
    }

    public ScriptedContainerBuilderFactory(URL compositionURL) {
        this(compositionURL, Thread.currentThread().getContextClassLoader(), new ScriptedBuilderNameResolver());
    }

    public ScriptedContainerBuilderFactory(URL compositionURL, ClassLoader classLoader, ScriptedBuilderNameResolver builderClassResolver) throws UnsupportedScriptTypeException {
        this(compositionURL, builderClassResolver.getBuilderClassName(compositionURL), classLoader);
    }

    public ScriptedContainerBuilderFactory(URL compositionURL, String builderClassName, ClassLoader classLoader) {
        this.createContainerBuilder(compositionURL, builderClassName, classLoader);
    }

    public ScriptedContainerBuilderFactory(Reader composition, String builderClassName) {
        this(composition, builderClassName, Thread.currentThread().getContextClassLoader());
    }

    public ScriptedContainerBuilderFactory(Reader composition, String builderClassName, ClassLoader classLoader) {
        this.createContainerBuilder(composition, builderClassName, classLoader);
    }

    private void createContainerBuilder(Object composition, String builderClassName, ClassLoader classLoader) {
        DefaultPicoContainer factory = new DefaultPicoContainer();
        if (composition == null) {
            throw new NullPointerException("composition can't be null");
        }
        factory.addComponent(composition);
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        factory.addComponent((Object)classLoader);
        DefaultClassLoadingPicoContainer defaultScriptedContainer = new DefaultClassLoadingPicoContainer(classLoader, (MutablePicoContainer)factory);
        ClassName className = new ClassName(builderClassName);
        MutablePicoContainer mutablePicoContainer = defaultScriptedContainer.addComponent((Object)className, (Object)className, new Parameter[0]);
        ComponentAdapter componentAdapter = mutablePicoContainer.getComponentAdapter((Object)className);
        this.containerBuilder = (ScriptedContainerBuilder)componentAdapter.getComponentInstance((PicoContainer)defaultScriptedContainer, ComponentAdapter.NOTHING.class);
    }

    private static File fileExists(File file) throws FileNotFoundException {
        if (file.exists()) {
            return file;
        }
        throw new FileNotFoundException("File " + file.getAbsolutePath() + " does not exist.");
    }

    public ScriptedContainerBuilder getContainerBuilder() {
        return this.containerBuilder;
    }
}

