/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.script;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.picocontainer.PicoContainer;
import org.picocontainer.script.ScriptedContainerBuilderFactory;

public class Standalone {
    private static final char HELP_OPT = 'h';
    private static final char VERSION_OPT = 'v';
    private static final char COMPOSITION_OPT = 'c';
    private static final char RESOURCE_OPT = 'r';
    private static final char QUIET_OPT = 'q';
    private static final char NOWAIT_OPT = 'n';
    private static final String DEFAULT_COMPOSITION_FILE = "composition.groovy";

    static final Options createOptions() {
        Options options = new Options();
        options.addOption(String.valueOf('h'), "help", false, "print this message and exit");
        options.addOption(String.valueOf('v'), "version", false, "print the version information and exit");
        options.addOption(String.valueOf('c'), "composition", true, "specify the composition file");
        options.addOption(String.valueOf('r'), "resource", true, "specify the composition file (as a resource read from classpath - like inside a jar)");
        options.addOption(String.valueOf('q'), "quiet", false, "forces ScriptedContainerBuilderFactory to be quiet");
        options.addOption(String.valueOf('n'), "nowait", false, "forces ScriptedContainerBuilderFactory to exit after start");
        return options;
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        new Standalone(args);
    }

    public Standalone(String[] args) throws IOException, ClassNotFoundException {
        File defaultCompositionFile = new File(DEFAULT_COMPOSITION_FILE);
        CommandLine cl = null;
        Options options = Standalone.createOptions();
        if (args.length == 0 && !defaultCompositionFile.exists()) {
            Standalone.printUsage(options);
            System.exit(-1);
        }
        try {
            cl = Standalone.getCommandLine(args, options);
        }
        catch (ParseException e) {
            System.out.println("PicoContainer Standalone: Error in parsing arguments: ");
            e.printStackTrace();
            System.exit(-1);
        }
        if (cl.hasOption('h')) {
            Standalone.printUsage(options);
            System.exit(0);
        }
        if (cl.hasOption('v')) {
            Standalone.printVersion();
            System.exit(0);
        }
        boolean quiet = cl.hasOption('q');
        boolean nowait = cl.hasOption('n');
        try {
            String compositionFile = cl.getOptionValue('c');
            String compositionResource = cl.getOptionValue('r');
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            if (compositionFile != null) {
                Standalone.buildAndStartContainer(new File(compositionFile), quiet, nowait);
            } else if (compositionResource != null) {
                Standalone.buildAndStartContainer(Standalone.class.getResource(compositionResource), quiet, nowait);
            } else if (defaultCompositionFile.exists()) {
                Standalone.buildAndStartContainer(defaultCompositionFile, quiet, nowait);
            } else {
                Standalone.printUsage(options);
                System.exit(10);
            }
        }
        catch (RuntimeException e) {
            System.err.println("PicoContainer Standalone: Failed to start application. Cause : " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        catch (ClassNotFoundException e) {
            System.err.println("PicoContainer Standalone: Failed to start application. A Class was not found. Exception message : " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        if (!quiet) {
            System.out.println("PicoContainer Standalone: Exiting main method.");
        }
    }

    private static void buildAndStartContainer(URL composition, boolean quiet, boolean nowait) throws ClassNotFoundException {
        ScriptedContainerBuilderFactory scriptedContainerBuilderFactory = new ScriptedContainerBuilderFactory(composition);
        Standalone.buildContainer(scriptedContainerBuilderFactory, nowait, quiet);
    }

    private static void buildAndStartContainer(File composition, boolean quiet, boolean nowait) throws IOException, ClassNotFoundException {
        ScriptedContainerBuilderFactory scriptedContainerBuilderFactory = new ScriptedContainerBuilderFactory(composition);
        Standalone.buildContainer(scriptedContainerBuilderFactory, nowait, quiet);
    }

    private static void buildContainer(ScriptedContainerBuilderFactory scriptedContainerBuilderFactory, boolean nowait, boolean quiet) {
        PicoContainer container = scriptedContainerBuilderFactory.getContainerBuilder().buildContainer(null, null, true);
        if (!nowait) {
            Standalone.setShutdownHook(quiet, scriptedContainerBuilderFactory, container);
        }
    }

    private static void setShutdownHook(final boolean quiet, final ScriptedContainerBuilderFactory scriptedContainerBuilderFactory, final PicoContainer container) {
        Runnable shutdownHook = new Runnable(){

            public void run() {
                Standalone.shuttingDown(quiet, scriptedContainerBuilderFactory, container);
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(shutdownHook));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shuttingDown(boolean quiet, ScriptedContainerBuilderFactory scriptedContainerBuilderFactory, PicoContainer container) {
        try {
            scriptedContainerBuilderFactory.getContainerBuilder().killContainer(container);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        finally {
            if (!quiet) {
                System.out.println("PicoContainer Standalone: Exiting Virtual Machine");
            }
        }
    }

    static CommandLine getCommandLine(String[] args, Options options) throws ParseException {
        PosixParser parser = new PosixParser();
        return parser.parse(options, args);
    }

    private static void printUsage(Options options) {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer usage = new StringBuffer();
        usage.append(lineSeparator);
        usage.append("PicoContainer Standalone: -c <composition-file> [-q|-n|-h|-v]");
        usage.append(options.getOptions());
        System.out.println(usage.toString());
    }

    private static void printVersion() {
        System.out.println("1.1");
    }
}

