/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.script.util;

import java.util.HashMap;
import java.util.Map;
import org.picocontainer.PicoCompositionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringConversions {
    private final Map<Class<?>, StringConverter<?>> converters = new HashMap();

    public StringConversions() {
        this.register(String.class, new StringConverter<String>(){

            @Override
            public String convert(String in) {
                return in;
            }
        });
        this.register(Integer.class, new StringConverter<Integer>(){

            @Override
            public Integer convert(String in) {
                return in == null ? 0 : Integer.valueOf(in);
            }
        });
        this.register(Long.class, new StringConverter<Long>(){

            @Override
            public Long convert(String in) {
                return in == null ? 0L : Long.valueOf(in);
            }
        });
        this.register(Boolean.class, new StringConverter<Boolean>(){

            @Override
            public Boolean convert(String in) {
                if (in == null || in.length() == 0) {
                    return Boolean.FALSE;
                }
                char c = in.toLowerCase().charAt(0);
                return c == '1' || c == 'y' || c == 't' ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public Object convertTo(Class<?> desiredClass, String inputString) {
        StringConverter<?> converter = this.converters.get(desiredClass);
        if (converter == null) {
            throw new InvalidConversionException("Cannot convert to type " + desiredClass.getName());
        }
        return converter.convert(inputString);
    }

    public void register(Class<?> type, StringConverter<?> converter) {
        this.converters.put(type, converter);
    }

    public static class InvalidConversionException
    extends PicoCompositionException {
        public InvalidConversionException(String message) {
            super(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface StringConverter<T> {
        public T convert(String var1);
    }
}

