/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.pitest.classpath.CodeSourceFactory;
import org.pitest.mutationtest.MutationEngineFactory;
import org.pitest.mutationtest.MutationResultInterceptor;
import org.pitest.mutationtest.MutationResultListenerFactory;
import org.pitest.mutationtest.build.CoverageTransformerFactory;
import org.pitest.mutationtest.build.MutationGrouperFactory;
import org.pitest.mutationtest.build.MutationInterceptorFactory;
import org.pitest.mutationtest.build.TestPrioritiserFactory;
import org.pitest.mutationtest.config.ConfigurationUpdater;
import org.pitest.mutationtest.config.Services;
import org.pitest.mutationtest.config.ServicesFromClassLoader;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.verify.BuildVerifierFactory;
import org.pitest.plugin.ClientClasspathPlugin;
import org.pitest.plugin.ProvidesFeature;
import org.pitest.plugin.ToolClasspathPlugin;
import org.pitest.testapi.TestPluginFactory;
import org.pitest.util.IsolationUtils;

public class PluginServices {
    private final Services loader;

    public PluginServices(Services loader) {
        this.loader = loader;
    }

    public static PluginServices makeForLoader(ClassLoader loader) {
        return new PluginServices(new ServicesFromClassLoader(loader));
    }

    public static PluginServices makeForContextLoader() {
        return PluginServices.makeForLoader(IsolationUtils.getContextClassLoader());
    }

    public Collection<? extends ToolClasspathPlugin> findToolClasspathPlugins() {
        ArrayList<Object> l = new ArrayList<Object>();
        l.addAll(this.findListeners());
        l.addAll(this.findGroupers());
        l.addAll(this.findTestPrioritisers());
        l.addAll(this.findInterceptors());
        l.addAll(this.findConfigurationUpdaters());
        l.addAll(this.findMutationResultInterceptor());
        l.addAll(this.findCoverageTransformers());
        l.addAll(this.findVerifiers());
        l.addAll(this.findCodeSources());
        return l;
    }

    public List<? extends ClientClasspathPlugin> findClientClasspathPlugins() {
        ArrayList<Object> l = new ArrayList<Object>();
        l.addAll(this.findMutationEngines());
        l.addAll(this.findMutationOperators());
        l.addAll(this.findTestFrameworkPlugins());
        l.addAll(this.nullPlugins());
        return l;
    }

    public Collection<? extends ConfigurationUpdater> findConfigurationUpdaters() {
        return this.load(ConfigurationUpdater.class);
    }

    public Collection<? extends MethodMutatorFactory> findMutationOperators() {
        return this.load(MethodMutatorFactory.class);
    }

    Collection<? extends TestPluginFactory> findTestFrameworkPlugins() {
        return this.load(TestPluginFactory.class);
    }

    Collection<? extends MutationGrouperFactory> findGroupers() {
        return this.load(MutationGrouperFactory.class);
    }

    Collection<? extends MutationResultListenerFactory> findListeners() {
        return this.load(MutationResultListenerFactory.class);
    }

    Collection<? extends MutationEngineFactory> findMutationEngines() {
        return this.load(MutationEngineFactory.class);
    }

    Collection<? extends TestPrioritiserFactory> findTestPrioritisers() {
        return this.load(TestPrioritiserFactory.class);
    }

    private Collection<ClientClasspathPlugin> nullPlugins() {
        return this.load(ClientClasspathPlugin.class);
    }

    public Collection<MutationInterceptorFactory> findInterceptors() {
        return this.load(MutationInterceptorFactory.class);
    }

    public List<BuildVerifierFactory> findVerifiers() {
        return new ArrayList<BuildVerifierFactory>(this.load(BuildVerifierFactory.class));
    }

    public List<MutationResultInterceptor> findMutationResultInterceptor() {
        return new ArrayList<MutationResultInterceptor>(this.load(MutationResultInterceptor.class));
    }

    public List<CoverageTransformerFactory> findCoverageTransformers() {
        return new ArrayList<CoverageTransformerFactory>(this.load(CoverageTransformerFactory.class));
    }

    public List<CodeSourceFactory> findCodeSources() {
        return new ArrayList<CodeSourceFactory>(this.load(CodeSourceFactory.class));
    }

    public Collection<ProvidesFeature> findFeatures() {
        return this.findToolClasspathPlugins().stream().filter(p -> p instanceof ProvidesFeature).map(ProvidesFeature.class::cast).collect(Collectors.toList());
    }

    private <S> Collection<S> load(Class<S> ifc) {
        return this.loader.load(ifc);
    }
}

