/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.verify;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.CodeSource;
import org.pitest.mutationtest.verify.BuildVerifier;

class KotlinVerifier
implements BuildVerifier {
    private final CodeSource code;

    KotlinVerifier(CodeSource code) {
        this.code = code;
    }

    @Override
    public List<String> verify() {
        if (this.kotlinIsOnClassPath() && !this.kotlinPluginIsPresent() && this.kotlinClassesToBeMutated()) {
            return Arrays.asList("Project uses kotlin, but the Arcmutate kotlin plugin is not on classpath (https://docs.arcmutate.com/docs/kotlin.html)");
        }
        return Collections.emptyList();
    }

    private boolean kotlinClassesToBeMutated() {
        return this.code.codeTrees().anyMatch(c -> c.rawNode().sourceFile != null && c.rawNode().sourceFile.endsWith(".kt"));
    }

    private boolean kotlinPluginIsPresent() {
        return this.code.fetchClassBytes(ClassName.fromString((String)"com.groupcdg.pitest.kotlin.KotlinFilterInterceptor")).isPresent();
    }

    private boolean kotlinIsOnClassPath() {
        return this.code.fetchClassBytes(ClassName.fromString((String)"kotlin.KotlinVersion")).isPresent();
    }
}

