/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.verify;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.CodeSource;
import org.pitest.mutationtest.verify.BuildVerifier;
import org.pitest.util.Log;

class MissingTestNGPluginVerifier
implements BuildVerifier {
    private final CodeSource code;

    MissingTestNGPluginVerifier(CodeSource code) {
        this.code = code;
    }

    @Override
    public List<String> verify() {
        if (!this.testNGPluginIsPresent() && this.testNGisPresent()) {
            String msg = "TestNG is on the classpath but the pitest TestNG plugin is not installed (https://github.com/pitest/pitest-testng-plugin)";
            Log.getLogger().warning(msg);
            return Arrays.asList(msg);
        }
        return Collections.emptyList();
    }

    private boolean testNGisPresent() {
        return this.code.fetchClassBytes(ClassName.fromString((String)"org.testng.annotations.Test")).isPresent();
    }

    private boolean testNGPluginIsPresent() {
        return this.code.fetchClassBytes(ClassName.fromString((String)"org.pitest.testng.TestNGPlugin")).isPresent();
    }
}

