/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.lombok;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.bytecode.analysis.OpcodeMatchers;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.build.intercept.Region;
import org.pitest.mutationtest.build.intercept.RegionInterceptor;
import org.pitest.sequence.Context;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.Result;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotWrite;

public class LombokNullFilter
extends RegionInterceptor {
    static final Slot<AbstractInsnNode> START = Slot.create(AbstractInsnNode.class);
    static final Slot<AbstractInsnNode> END = Slot.create(AbstractInsnNode.class);
    static final SequenceMatcher<AbstractInsnNode> NULL_CHECK = QueryStart.any(AbstractInsnNode.class).then(OpcodeMatchers.ALOAD.and(LombokNullFilter.store(START.write()))).then(OpcodeMatchers.IFNONNULL).then(InstructionMatchers.newCall(ClassName.fromClass(NullPointerException.class))).then(OpcodeMatchers.DUP).then(InstructionMatchers.ldcString(s -> s.endsWith("is marked non-null but is null"))).then(OpcodeMatchers.INVOKESPECIAL).then(OpcodeMatchers.ATHROW.and(LombokNullFilter.store(END.write()))).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(InstructionMatchers.notAnInstruction().or(InstructionMatchers.isA(LabelNode.class))));

    private static Match<AbstractInsnNode> store(SlotWrite<AbstractInsnNode> slot) {
        return (c, n) -> Result.result(true, c.store(slot, n));
    }

    @Override
    protected List<Region> computeRegions(MethodTree method) {
        if (!this.hasLombokNonNullAnnotation(method)) {
            return Collections.emptyList();
        }
        Context context = Context.start();
        return NULL_CHECK.contextMatches(method.instructions(), context).stream().map(c -> new Region(c.retrieve(START.read()).get(), c.retrieve(END.read()).get())).collect(Collectors.toList());
    }

    private boolean hasLombokNonNullAnnotation(MethodTree method) {
        if (method.rawNode().invisibleParameterAnnotations == null) {
            return false;
        }
        return Arrays.stream(method.rawNode().invisibleParameterAnnotations).filter(l -> l != null).flatMap(l -> l.stream().filter(node -> node.desc.equals("Llombok/NonNull;"))).findAny().isPresent();
    }
}

