/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.r2dbc.postgresql.codec.Point;
import io.r2dbc.postgresql.util.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Polygon {
    private final List<Point> points;

    private Polygon(List<Point> points) {
        Assert.requireNonNull(points, "points must not be null");
        this.points = Collections.unmodifiableList(new ArrayList<Point>(points));
    }

    public static Polygon of(List<Point> points) {
        return new Polygon(points);
    }

    public static Polygon of(Point ... points) {
        Assert.requireNonNull(points, "points must not be null");
        return new Polygon(Arrays.asList(points));
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Polygon polygon = (Polygon)o;
        return this.points.equals(polygon.points);
    }

    public int hashCode() {
        return Objects.hash(this.points);
    }

    public String toString() {
        return "(" + this.points.stream().map(Point::toString).collect(Collectors.joining(", ")) + ")";
    }
}

