/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.AbstractNumericCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.codec.PrimitiveCodec;
import io.r2dbc.postgresql.codec.PrimitiveWrapperCodecProvider;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import org.jspecify.annotations.Nullable;

final class FloatCodec
extends AbstractNumericCodec<Float>
implements PrimitiveWrapperCodecProvider<Float> {
    FloatCodec(ByteBufAllocator byteBufAllocator) {
        super(Float.class, byteBufAllocator);
    }

    @Override
    public PrimitiveCodec<Float> getPrimitiveCodec() {
        return new PrimitiveCodec<Float>(Float.TYPE, Float.class, this);
    }

    @Override
    Float doDecode(ByteBuf buffer, PostgresTypeIdentifier dataType, Format format, @Nullable Class<? extends Float> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        Assert.requireNonNull(format, "format must not be null");
        return this.decodeNumber(buffer, dataType, format, Float.class, Number::floatValue);
    }

    @Override
    PostgresqlObjectId getDefaultType() {
        return PostgresqlObjectId.FLOAT4;
    }

    @Override
    public PostgresTypeIdentifier getArrayDataType() {
        return PostgresqlObjectId.FLOAT4_ARRAY;
    }
}

