/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.AbstractTemporalCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlDateTimeFormatter;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

final class InstantCodec
extends AbstractTemporalCodec<Instant> {
    private final Supplier<ZoneId> zoneIdSupplier;

    InstantCodec(ByteBufAllocator byteBufAllocator, Supplier<ZoneId> zoneIdSupplier) {
        super(Instant.class, byteBufAllocator, PostgresqlObjectId.TIMESTAMPTZ, PostgresqlObjectId.TIMESTAMPTZ_ARRAY, it -> PostgresqlDateTimeFormatter.toString(it));
        this.zoneIdSupplier = zoneIdSupplier;
    }

    @Override
    Instant doDecode(ByteBuf buffer, PostgresTypeIdentifier dataType, @Nullable Format format, Class<? extends Instant> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return this.decodeTemporal(buffer, dataType, format, Instant.class, temporal -> {
            if (temporal instanceof LocalDateTime) {
                ZoneId zoneId = this.zoneIdSupplier.get();
                ZoneOffset offset = zoneId.getRules().getOffset((LocalDateTime)temporal);
                return ((LocalDateTime)temporal).toInstant(offset);
            }
            if (temporal instanceof LocalDate) {
                ZoneId zoneId = this.zoneIdSupplier.get();
                return ((LocalDate)temporal).atStartOfDay(zoneId).toInstant();
            }
            return Instant.from(temporal);
        });
    }

    @Override
    PostgresqlObjectId getDefaultType() {
        return null;
    }
}

