/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.AbstractNumericCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.codec.PrimitiveCodec;
import io.r2dbc.postgresql.codec.PrimitiveWrapperCodecProvider;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import org.jspecify.annotations.Nullable;

final class IntegerCodec
extends AbstractNumericCodec<Integer>
implements PrimitiveWrapperCodecProvider<Integer> {
    IntegerCodec(ByteBufAllocator byteBufAllocator) {
        super(Integer.class, byteBufAllocator);
    }

    @Override
    public boolean isPreferred(int dataType, Format format, Class<?> type) {
        return IntegerCodec.isPreferenceType(type) && dataType == PostgresqlObjectId.OID.getObjectId() || super.isPreferred(dataType, format, type);
    }

    @Override
    public PrimitiveCodec<Integer> getPrimitiveCodec() {
        return new PrimitiveCodec<Integer>(Integer.TYPE, Integer.class, this);
    }

    @Override
    Integer doDecode(ByteBuf buffer, PostgresTypeIdentifier dataType, @Nullable Format format, @Nullable Class<? extends Integer> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        Assert.requireNonNull(format, "format must not be null");
        return this.decodeNumber(buffer, dataType, format, Integer.class, Number::intValue);
    }

    @Override
    PostgresqlObjectId getDefaultType() {
        return PostgresqlObjectId.INT4;
    }

    @Override
    public PostgresTypeIdentifier getArrayDataType() {
        return PostgresqlObjectId.INT4_ARRAY;
    }
}

