/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.extension.listener;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import org.powermock.api.easymock.EasyMockConfiguration;
import org.powermock.api.easymock.annotation.MockNice;
import org.powermock.api.easymock.annotation.MockStrict;
import org.powermock.api.extension.InjectFieldSearcher;
import org.powermock.api.extension.listener.AnnotationGlobalMetadata;
import org.powermock.api.extension.listener.AnnotationMockCreator;
import org.powermock.api.extension.listener.AnnotationMockCreatorFactory;
import org.powermock.api.extension.listener.AnnotationMockScanner;
import org.powermock.api.extension.listener.DefaultInjectFieldSearcher;
import org.powermock.api.extension.listener.MockMetadata;
import org.powermock.api.extension.listener.TestSubjectInjector;
import org.powermock.core.classloader.annotations.Mock;

public class EasyMockAnnotationSupport {
    private final Object testInstance;
    private final AnnotationMockCreatorFactory annotationMockCreatorFactory;
    private final AnnotationGlobalMetadata globalMetadata;
    private final EasyMockConfiguration easyMockConfiguration;

    public EasyMockAnnotationSupport(Object testInstance) {
        this.testInstance = testInstance;
        this.annotationMockCreatorFactory = new AnnotationMockCreatorFactory();
        this.globalMetadata = new AnnotationGlobalMetadata();
        this.easyMockConfiguration = EasyMockConfiguration.getConfiguration();
    }

    public void injectMocks() throws Exception {
        this.injectStrictMocks();
        this.injectNiceMocks();
        this.injectDefaultMocks();
        this.injectTestSubjectMocks();
    }

    protected void injectStrictMocks() throws Exception {
        this.inject(this.testInstance, MockStrict.class, this.annotationMockCreatorFactory.createStrictMockCreator());
    }

    protected void injectNiceMocks() throws Exception {
        this.inject(this.testInstance, MockNice.class, this.annotationMockCreatorFactory.createNiceMockCreator());
    }

    protected void injectDefaultMocks() throws Exception {
        this.inject(this.testInstance, org.powermock.api.easymock.annotation.Mock.class, this.annotationMockCreatorFactory.createDefaultMockCreator());
        this.inject(this.testInstance, Mock.class, this.annotationMockCreatorFactory.createDefaultMockCreator());
    }

    protected void injectTestSubjectMocks() throws IllegalAccessException {
        if (this.easyMockConfiguration.isTestSubjectSupported()) {
            TestSubjectInjector testSubjectInjector = new TestSubjectInjector(this.testInstance, this.globalMetadata);
            testSubjectInjector.injectTestSubjectMocks();
        }
    }

    protected void inject(Object injectCandidateInstance, Class<? extends Annotation> annotation, AnnotationMockCreator mockCreator) throws Exception {
        AnnotationMockScanner scanner = new AnnotationMockScanner(annotation);
        List<MockMetadata> mocksMetadata = scanner.scan(injectCandidateInstance);
        this.globalMetadata.add(mocksMetadata);
        for (MockMetadata mockMetadata : mocksMetadata) {
            this.injectMock(injectCandidateInstance, mockMetadata, mockCreator, new DefaultInjectFieldSearcher());
        }
    }

    protected void injectMock(Object injectCandidateInstance, MockMetadata mockMetadata, AnnotationMockCreator mockCreator, InjectFieldSearcher fieldSearch) throws IllegalAccessException {
        Object mock = this.createMock(mockCreator, mockMetadata);
        Field field = fieldSearch.findField(injectCandidateInstance, mockMetadata);
        if (field != null && mock != null) {
            field.setAccessible(true);
            field.set(injectCandidateInstance, mock);
        }
    }

    protected Object createMock(AnnotationMockCreator mockCreator, MockMetadata mockMetadata) {
        if (mockMetadata.getMock() == null) {
            Object mock = mockCreator.createMockInstance(mockMetadata.getType(), mockMetadata.getMethods());
            mockMetadata.setMock(mock);
        }
        return mockMetadata.getMock();
    }
}

