/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.configuration;

import org.powermock.configuration.Configuration;
import org.powermock.configuration.MockitoConfiguration;
import org.powermock.configuration.PowerMockConfiguration;

public enum ConfigurationType {
    Mockito("mockito", MockitoConfiguration.class),
    PowerMock("powermock", PowerMockConfiguration.class);

    private final String prefix;
    private final Class<? extends Configuration> configurationClass;

    private ConfigurationType(String prefix, Class<? extends Configuration> configurationClass) {
        this.prefix = prefix;
        this.configurationClass = configurationClass;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static <T extends Configuration> ConfigurationType forClass(Class<T> configurationClass) {
        for (ConfigurationType configurationType : ConfigurationType.values()) {
            if (!configurationType.configurationClass.isAssignableFrom(configurationClass)) continue;
            return configurationType;
        }
        return null;
    }
}

