/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.converter;

import java.io.Serializable;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;
import org.owasp.html.Encoding;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;
import org.primefaces.util.LangUtils;

@FacesConverter(value="primefaces.SanitizingConverter")
public class SanitizingConverter
implements Converter<Object>,
Serializable {
    private static final long serialVersionUID = 20121214L;
    private static final PolicyFactory DEFAULT_POLICY = new HtmlPolicyBuilder().toFactory();
    private PolicyFactory policy;
    private boolean decodeHtml = true;

    public String sanitize(String value) {
        if (LangUtils.isBlank((String)value)) {
            return value;
        }
        String result = this.getPolicy().sanitize(value);
        if (this.isDecodeHtml()) {
            result = Encoding.decodeHtml((String)result);
        }
        return result.trim();
    }

    public Object getAsObject(FacesContext fc, UIComponent uic, String value) {
        return value == null ? null : this.sanitize(value);
    }

    public String getAsString(FacesContext fc, UIComponent uic, Object o) {
        return o == null ? "" : this.sanitize(o.toString());
    }

    public PolicyFactory getPolicy() {
        if (this.policy == null) {
            this.policy = DEFAULT_POLICY;
        }
        return this.policy;
    }

    public void setPolicy(PolicyFactory policy) {
        this.policy = policy;
    }

    public boolean isDecodeHtml() {
        return this.decodeHtml;
    }

    public void setDecodeHtml(boolean decodeHtml) {
        this.decodeHtml = decodeHtml;
    }
}

