/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.inputphone;

import jakarta.faces.FacesException;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.primefaces.extensions.component.inputphone.InputPhone;
import org.primefaces.extensions.config.PrimeExtensionsEnvironment;
import org.primefaces.extensions.util.PhoneNumberUtilWrapper;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.shaded.json.JSONArray;
import org.primefaces.shaded.json.JSONObject;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class InputPhoneRenderer
extends InputRenderer {
    private static final Logger LOGGER = Logger.getLogger(InputPhoneRenderer.class.getName());
    private static final String HIDDEN_ID = "_iso2";

    public void decode(FacesContext context, UIComponent component) {
        InputPhone inputPhone = (InputPhone)component;
        if (!this.shouldDecode((UIInput)inputPhone)) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)inputPhone);
        String inputId = inputPhone.getClientId(context) + "_input";
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(inputId);
        if (submittedValue != null) {
            inputPhone.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputPhone inputPhone = (InputPhone)component;
        Object value = inputPhone.getValue();
        String valueToRender = ComponentUtils.getValueToRender((FacesContext)context, (UIComponent)inputPhone, (Object)value);
        if (valueToRender == null) {
            valueToRender = "";
        }
        this.encodeMarkup(context, inputPhone, valueToRender);
        this.encodeScript(context, inputPhone);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) {
        String value = (String)submittedValue;
        if (LangUtils.isBlank((String)value)) {
            return null;
        }
        InputPhone inputPhone = (InputPhone)component;
        Converter converter = inputPhone.getConverter();
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)inputPhone, value);
        }
        String country = (String)context.getExternalContext().getRequestParameterMap().get(inputPhone.getClientId() + HIDDEN_ID);
        if (country == null || "auto".equals(country)) {
            country = "";
        }
        if (PrimeExtensionsEnvironment.getCurrentInstance(context).isLibphonenumberAvailable()) {
            PhoneNumberUtilWrapper.validate(value, country.toUpperCase(), inputPhone.getValidatorMessage());
        } else {
            LOGGER.warning("Libphonenumber not available, unable to validate!");
        }
        return value;
    }

    protected void encodeMarkup(FacesContext context, InputPhone inputPhone, String valueToRender) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputPhone.getClientId(context);
        String styleClass = this.getStyleClassBuilder(context).add("ui-inputphone ui-widget").add(inputPhone.getStyleClass()).build();
        writer.startElement("span", (UIComponent)inputPhone);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (inputPhone.getStyle() != null) {
            writer.writeAttribute("style", (Object)inputPhone.getStyle(), "style");
        }
        this.encodeInput(context, inputPhone, clientId, valueToRender);
        this.encodeHiddenInput(context, inputPhone, clientId);
        writer.endElement("span");
    }

    protected void encodeInput(FacesContext context, InputPhone inputPhone, String clientId, String valueToRender) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = clientId + "_input";
        String inputStyle = inputPhone.getInputStyle();
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)inputPhone.getType(), null);
        writer.writeAttribute("value", (Object)valueToRender, null);
        writer.writeAttribute("class", (Object)this.createStyleClass((UIInput)inputPhone, "ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all"), "styleClass");
        if (!this.isValueBlank(inputStyle)) {
            writer.writeAttribute("style", (Object)inputStyle, null);
        }
        this.renderAccessibilityAttributes(context, (UIInput)inputPhone);
        this.renderPassThruAttributes(context, (UIComponent)inputPhone, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)inputPhone, HTML.INPUT_TEXT_EVENTS);
        this.renderValidationMetadata(context, (EditableValueHolder)inputPhone);
        writer.endElement("input");
    }

    protected void encodeHiddenInput(FacesContext context, InputPhone inputPhone, String clientId) throws IOException {
        this.renderHiddenInput(context, clientId + HIDDEN_ID, inputPhone.getInitialCountry(), inputPhone.isDisabled());
    }

    protected void encodeScript(FacesContext context, InputPhone inputPhone) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtInputPhone", (UIComponent)inputPhone);
        if (!inputPhone.isAllowDropdown()) {
            wb.attr("allowDropdown", Boolean.valueOf(inputPhone.isAllowDropdown()));
        }
        if (!inputPhone.isAutoHideDialCode()) {
            wb.attr("autoHideDialCode", Boolean.valueOf(inputPhone.isAutoHideDialCode()));
        }
        if (inputPhone.getAutoPlaceholderEnum() != InputPhone.AutoPlaceholder.polite) {
            wb.attr("autoPlaceholder", inputPhone.getAutoPlaceholder());
        }
        this.encodeCountries(wb, "excludeCountries", inputPhone.getExcludeCountries());
        if (!inputPhone.isFormatOnDisplay()) {
            wb.attr("formatOnDisplay", Boolean.valueOf(inputPhone.isFormatOnDisplay()));
        }
        if (LangUtils.isNotBlank((String)inputPhone.getInitialCountry())) {
            wb.attr("initialCountry", inputPhone.getInitialCountry());
        }
        if ("auto".equals(inputPhone.getInitialCountry())) {
            if (inputPhone.getGeoIpLookup() == null) {
                throw new FacesException("InputPhone geoIpLookup property is required when initialCountry is 'auto'.");
            }
            wb.nativeAttr("geoIpLookup", inputPhone.getGeoIpLookup());
        }
        if (!inputPhone.isNationalMode()) {
            wb.attr("nationalMode", Boolean.valueOf(inputPhone.isNationalMode()));
        }
        this.encodeCountries(wb, "onlyCountries", inputPhone.getOnlyCountries());
        if (inputPhone.getPlaceholderNumberTypeEnum() != InputPhone.PlaceholderNumberType.mobile) {
            wb.attr("placeholderNumberType", inputPhone.getPlaceholderNumberType().toUpperCase());
        }
        this.encodeCountries(wb, "preferredCountries", inputPhone.getPreferredCountries());
        if (inputPhone.isSeparateDialCode()) {
            wb.attr("separateDialCode", Boolean.valueOf(inputPhone.isSeparateDialCode()));
        }
        if (inputPhone.isUtilsScriptRequired()) {
            wb.attr("utilsScript", context.getApplication().getResourceHandler().createResource("inputphone/utils.js", "primefaces-extensions").getRequestPath());
        }
        if (inputPhone.getLocalizedCountries() != null) {
            wb.nativeAttr("localizedCountries", this.objectToJsonString(inputPhone.getLocalizedCountries()));
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)inputPhone);
        wb.finish();
    }

    private void encodeCountries(WidgetBuilder wb, String attribute, Object value) throws IOException {
        Collection<String> countries = this.toCollection(value);
        if (!countries.isEmpty()) {
            wb.nativeAttr(attribute, new JSONArray(countries).toString());
        }
    }

    private Collection<String> toCollection(Object object) {
        if (object instanceof String) {
            String string = ((String)object).replace(' ', ',').toLowerCase();
            return Arrays.asList(string.split(","));
        }
        return (Collection)object;
    }

    private String objectToJsonString(Object object) {
        if (object == null || object instanceof String) {
            return (String)object;
        }
        Map map = (Map)object;
        JSONObject jsonObj = new JSONObject();
        map.entrySet().forEach(entry -> jsonObj.put((String)entry.getKey(), entry.getValue()));
        return jsonObj.toString();
    }
}

