/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.application;

import jakarta.faces.FacesException;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.SystemEvent;
import jakarta.faces.event.SystemEventListener;
import jakarta.faces.lifecycle.ClientWindow;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.primefaces.clientwindow.PrimeClientWindow;
import org.primefaces.clientwindow.PrimeClientWindowUtils;
import org.primefaces.config.PrimeConfiguration;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.extensions.util.ResourceExtUtils;
import org.primefaces.util.LocaleUtils;

public class PrimeFacesScriptProcessor
implements SystemEventListener {
    private static final Logger LOGGER = Logger.getLogger(PrimeFacesScriptProcessor.class.getName());

    public boolean isListenerForSource(Object source) {
        return source instanceof UIViewRoot;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        FacesContext context = event.getFacesContext();
        if (context.getPartialViewContext().isAjaxRequest()) {
            return;
        }
        boolean shouldDiscard = Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(element -> "org.apache.myfaces.lifecycle.RestoreViewExecutor".equals(element.getClassName()));
        if (shouldDiscard) {
            return;
        }
        PrimeRequestContext requestContext = PrimeRequestContext.getCurrentInstance((FacesContext)context);
        PrimeApplicationContext applicationContext = requestContext.getApplicationContext();
        PrimeConfiguration configuration = applicationContext.getConfig();
        this.encodeValidationResources(context, configuration);
        this.encodeLocaleResources(context, configuration);
        StringBuilder script = new StringBuilder(4000);
        this.encodeSettingScripts(context, script);
        this.encodeInitScripts(context, script);
        ResourceExtUtils.addScriptToHead(context, script.toString());
    }

    protected void encodeValidationResources(FacesContext context, PrimeConfiguration configuration) {
        if (configuration.isClientSideValidationEnabled()) {
            ResourceExtUtils.addJavascriptResource(context, "primefaces", "moment/moment.js");
            if (configuration.isBeanValidationEnabled()) {
                ResourceExtUtils.addJavascriptResource(context, "primefaces", "validation/validation.bv.js");
            }
        }
    }

    protected void encodeLocaleResources(FacesContext context, PrimeConfiguration configuration) {
        block3: {
            if (!configuration.isClientSideLocalizationEnabled()) {
                return;
            }
            try {
                Locale locale = LocaleUtils.getCurrentLocale((FacesContext)context);
                ResourceExtUtils.addJavascriptResource(context, "primefaces", "locales/locale-" + locale.getLanguage() + ".js");
            }
            catch (FacesException e) {
                if (!context.isProjectStage(ProjectStage.Development)) break block3;
                LOGGER.log(Level.WARNING, "Failed to load client side locale.js. {0}", e.getMessage());
            }
        }
    }

    protected void encodeSettingScripts(FacesContext context, StringBuilder writer) {
        PrimeRequestContext requestContext = PrimeRequestContext.getCurrentInstance((FacesContext)context);
        PrimeApplicationContext applicationContext = requestContext.getApplicationContext();
        PrimeConfiguration configuration = applicationContext.getConfig();
        ProjectStage projectStage = context.getApplication().getProjectStage();
        ExternalContext externalContext = context.getExternalContext();
        writer.append("if(window.PrimeFaces){");
        writer.append("PrimeFaces.settings={").append("locale:'").append(LocaleUtils.getCurrentLocale((FacesContext)context)).append("',").append("viewId:'").append(context.getViewRoot().getViewId()).append("',").append("contextPath:'").append(externalContext.getRequestContextPath()).append("',").append("cookiesSecure:").append(requestContext.isSecure() && configuration.isCookiesSecure());
        String cookiesSameSite = configuration.getCookiesSameSite();
        if (cookiesSameSite != null) {
            writer.append(",cookiesSameSite:'").append(cookiesSameSite).append("'");
        }
        if (configuration.isClientSideValidationEnabled()) {
            writer.append(",validateEmptyFields:").append(configuration.isValidateEmptyFields()).append(",considerEmptyStringNull:").append(configuration.isInterpretEmptyStringAsNull());
        }
        if (configuration.isEarlyPostParamEvaluation()) {
            writer.append(",earlyPostParamEvaluation:true");
        }
        if (configuration.isPartialSubmitEnabled()) {
            writer.append(",partialSubmit:true");
        }
        if (projectStage != ProjectStage.Production) {
            writer.append(",projectStage:'").append(projectStage.toString()).append("'");
        }
        writer.append("};");
        ClientWindow clientWindow = externalContext.getClientWindow();
        if (clientWindow instanceof PrimeClientWindow) {
            boolean initialRedirect = false;
            Object cookie = PrimeClientWindowUtils.getInitialRedirectCookie((FacesContext)context, (String)clientWindow.getId());
            if (cookie instanceof Cookie) {
                Cookie servletCookie = (Cookie)cookie;
                initialRedirect = true;
                servletCookie.setMaxAge(0);
                ((HttpServletResponse)externalContext.getResponse()).addCookie(servletCookie);
            }
            writer.append("PrimeFaces.clientwindow.init('").append(PrimeClientWindowUtils.secureWindowId((String)clientWindow.getId())).append("',").append(initialRedirect).append(");");
        }
        writer.append("}");
    }

    protected void encodeInitScripts(FacesContext context, StringBuilder writer) {
        PrimeRequestContext requestContext = PrimeRequestContext.getCurrentInstance((FacesContext)context);
        List scripts = requestContext.getInitScriptsToExecute();
        if (scripts.isEmpty()) {
            return;
        }
        boolean moveScriptsToBottom = requestContext.getApplicationContext().getConfig().isMoveScriptsToBottom();
        if (!moveScriptsToBottom) {
            writer.append("(function(){const pfInit=()=>{").append(String.join((CharSequence)";", scripts)).append("};if(window.$){$(pfInit)}").append("else if(document.readyState==='complete'){pfInit()}").append("else{document.addEventListener('DOMContentLoaded',pfInit)}").append("})();");
        } else {
            writer.append(String.join((CharSequence)";", scripts)).append(';');
        }
    }
}

