/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.base;

import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import java.io.Serializable;
import java.util.logging.Logger;
import org.primefaces.component.api.AbstractPrimeHtmlInputTextArea;
import org.primefaces.component.api.RTLAware;
import org.primefaces.component.api.Widget;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.extensions.util.HtmlSanitizer;

public class AbstractEditorInputTextArea
extends AbstractPrimeHtmlInputTextArea
implements Widget,
RTLAware {
    private static final Logger LOGGER = Logger.getLogger(AbstractEditorInputTextArea.class.getName());

    public void setDir(String _dir) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dir), (Object)_dir);
    }

    public String getDir() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dir), (Object)"ltr");
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)widgetVar);
    }

    public boolean isSecure() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.secure), (Object)true);
    }

    public void setSecure(boolean secure) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.secure), (Object)secure);
    }

    public boolean isAllowBlocks() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.allowBlocks), (Object)true);
    }

    public void setAllowBlocks(boolean allowBlocks) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.allowBlocks), (Object)allowBlocks);
    }

    public boolean isAllowFormatting() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.allowFormatting), (Object)true);
    }

    public void setAllowFormatting(boolean allowFormatting) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.allowFormatting), (Object)allowFormatting);
    }

    public boolean isAllowLinks() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.allowLinks), (Object)true);
    }

    public void setAllowLinks(boolean allowLinks) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.allowLinks), (Object)allowLinks);
    }

    public boolean isAllowStyles() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.allowStyles), (Object)true);
    }

    public void setAllowStyles(boolean allowStyles) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.allowStyles), (Object)allowStyles);
    }

    public boolean isAllowImages() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.allowImages), (Object)true);
    }

    public void setAllowImages(boolean allowImages) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.allowImages), (Object)allowImages);
    }

    public boolean isAllowTables() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.allowTables), (Object)true);
    }

    public void setAllowMedia(boolean allowMedia) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.allowMedia), (Object)allowMedia);
    }

    public boolean isAllowMedia() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.allowMedia), (Object)true);
    }

    public void setAllowTables(boolean allowTables) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.allowTables), (Object)allowTables);
    }

    public String getExtender() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.extender), null);
    }

    public void setExtender(String extender) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.extender), (Object)extender);
    }

    public String getToolbar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.toolbar), null);
    }

    public void setToolbar(String toolbar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.toolbar), (Object)toolbar);
    }

    public void checkSecurity(FacesContext context) {
        boolean sanitizerAvailable = PrimeApplicationContext.getCurrentInstance((FacesContext)context).getEnvironment().isHtmlSanitizerAvailable();
        if (this.isSecure() && !sanitizerAvailable) {
            throw new FacesException("Editor component is marked secure='true' but the HTML Sanitizer was not found on the classpath. Either add the HTML sanitizer to the classpath per the documentation or mark secure='false' if you would like to use the component without the sanitizer.");
        }
    }

    public String sanitizeHtml(FacesContext context, String value) {
        String result = value;
        if (this.isSecure() && PrimeApplicationContext.getCurrentInstance((FacesContext)context).getEnvironment().isHtmlSanitizerAvailable()) {
            result = HtmlSanitizer.sanitizeHtml(value, this.isAllowBlocks(), this.isAllowFormatting(), this.isAllowLinks(), this.isAllowStyles(), this.isAllowImages(), this.isAllowTables(), this.isAllowMedia());
        } else if (!(this.isAllowBlocks() && this.isAllowFormatting() && this.isAllowLinks() && this.isAllowStyles() && this.isAllowImages() && this.isAllowTables())) {
            LOGGER.warning("HTML sanitizer not available - skip sanitizing....");
        }
        return result;
    }

    protected static enum PropertyKeys {
        widgetVar,
        dir,
        allowBlocks,
        allowFormatting,
        allowLinks,
        allowStyles,
        allowImages,
        allowTables,
        allowMedia,
        secure,
        extender,
        toolbar;

    }
}

