/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.blockui;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.extensions.component.blockui.BlockUI;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class BlockUIRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext fc, UIComponent component) throws IOException {
        this.encodeMarkup(fc, component);
        this.encodeScript(fc, component);
    }

    protected void encodeMarkup(FacesContext fc, UIComponent component) throws IOException {
        BlockUI blockUI = (BlockUI)component;
        if (blockUI.getContent() == null && blockUI.getChildCount() > 0) {
            ResponseWriter writer = fc.getResponseWriter();
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)(blockUI.getClientId(fc) + "_content"), null);
            writer.writeAttribute("style", (Object)"display: none;", null);
            this.renderChildren(fc, component);
            writer.endElement("div");
        }
    }

    protected void encodeScript(FacesContext fc, UIComponent component) throws IOException {
        BlockUI blockUI = (BlockUI)component;
        String clientId = blockUI.getClientId(fc);
        String source = blockUI.getSource();
        source = source == null ? blockUI.getParent().getClientId(fc) : SearchExpressionUtils.resolveClientIdForClientSide((FacesContext)fc, (UIComponent)blockUI, (String)source);
        if (source == null) {
            throw new FacesException("Cannot find source for blockUI component '" + clientId + "'.");
        }
        String target = blockUI.getTarget();
        if (target != null) {
            target = SearchExpressionUtils.resolveClientIdForClientSide((FacesContext)fc, (UIComponent)blockUI, (String)target);
        }
        String jqContent = null;
        boolean isContentExtern = false;
        if (blockUI.getContent() != null) {
            UIComponent contentComponent = blockUI.findComponent(blockUI.getContent());
            if (contentComponent == null) {
                throw new FacesException("Cannot find content for blockUI component '" + clientId + "'.");
            }
            jqContent = "#" + contentComponent.getClientId(fc);
            isContentExtern = true;
        } else if (blockUI.getChildCount() > 0) {
            jqContent = "#" + clientId + "_content";
        }
        String events = blockUI.getEvent();
        Object eventRegEx = LangUtils.isBlank((String)events) ? "/jakarta.faces.source=" + source + "(.)*$/" : this.getEventRegEx(events);
        WidgetBuilder wb = this.getWidgetBuilder(fc);
        wb.init("ExtBlockUI", (UIComponent)blockUI);
        wb.attr("source", source);
        wb.attr("target", target, null);
        wb.attr("autoShow", Boolean.valueOf(blockUI.isAutoShow()));
        wb.attr("focusInput", Boolean.valueOf(blockUI.isFocusInput()));
        wb.attr("showOverlay", Boolean.valueOf(blockUI.isShowOverlay()));
        wb.attr("centerX", Boolean.valueOf(blockUI.isCenterX()));
        wb.attr("centerY", Boolean.valueOf(blockUI.isCenterY()));
        wb.attr("fadeIn", (Number)blockUI.getFadeIn());
        wb.attr("fadeOut", (Number)blockUI.getFadeOut());
        wb.nativeAttr("css", blockUI.getCss());
        wb.nativeAttr("overlayCSS", blockUI.getCssOverlay());
        wb.attr("timeout", blockUI.getTimeout(), 0);
        wb.selectorAttr("content", jqContent);
        wb.attr("contentExtern", Boolean.valueOf(isContentExtern));
        wb.attr("namingContSep", Character.toString(UINamingContainer.getSeparatorChar((FacesContext)fc)));
        wb.nativeAttr("regEx", (String)eventRegEx);
        wb.finish();
    }

    protected String getEventRegEx(String events) {
        String[] arrEvents = events.split("[\\s,]+");
        StringBuilder sb = new StringBuilder("/");
        for (int i = 0; i < arrEvents.length; ++i) {
            sb.append("jakarta.faces.behavior.event");
            sb.append("=");
            sb.append(arrEvents[i]);
            if (i + 1 >= arrEvents.length) continue;
            sb.append("|");
        }
        sb.append("/");
        return sb.toString();
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext fc, UIComponent component) {
    }
}

