/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.creditcard;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.extensions.component.creditcard.CreditCard;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class CreditCardRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        CreditCard creditCard = (CreditCard)component;
        this.encodeMarkup(context, creditCard);
        this.encodeScript(context, creditCard);
    }

    protected void encodeMarkup(FacesContext context, CreditCard creditCard) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = creditCard.getClientId(context);
        String widgetVar = creditCard.resolveWidgetVar();
        String styleClass = "ui-credit-card ";
        writer.startElement("div", (UIComponent)creditCard);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("data-widget", (Object)widgetVar, null);
        writer.writeAttribute("class", (Object)"ui-credit-card ", "styleClass");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, CreditCard creditCard) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtCreditCard", (UIComponent)creditCard);
        wb.attr("width", creditCard.getWidth(), 350);
        wb.attr("formatting", creditCard.isFormatting(), true);
        wb.nativeAttr("messages", "{validDate:'" + creditCard.getLabelValidDate() + "',monthYear:'" + creditCard.getLabelMonthYear() + "'}");
        StringBuilder placeholder = new StringBuilder(1024);
        placeholder.append("{name:'").append(creditCard.getPlaceholderName()).append("'");
        if (!LangUtils.isBlank((String)creditCard.getPlaceholderNumber())) {
            placeholder.append(",number:'").append(creditCard.getPlaceholderNumber()).append("'");
        }
        if (!LangUtils.isBlank((String)creditCard.getPlaceholderExpiry())) {
            placeholder.append(",expiry:'").append(creditCard.getPlaceholderExpiry()).append("'");
        }
        if (!LangUtils.isBlank((String)creditCard.getPlaceholderCvc())) {
            placeholder.append(",cvc:'").append(creditCard.getPlaceholderCvc()).append("'");
        }
        placeholder.append("}");
        wb.nativeAttr("placeholders", placeholder.toString());
        wb.finish();
    }
}

