/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.markdowneditor;

import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import java.io.IOException;
import java.util.Map;
import org.primefaces.component.api.RTLAware;
import org.primefaces.extensions.component.markdowneditor.MarkdownEditor;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.WidgetBuilder;
import org.primefaces.validate.ClientValidator;

public class MarkdownEditorRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        MarkdownEditor editor = (MarkdownEditor)component;
        if (!this.shouldDecode((UIInput)editor)) {
            return;
        }
        String clientId = editor.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId)) {
            String value = editor.sanitizeHtml(context, (String)params.get(clientId));
            editor.setSubmittedValue(value);
        }
        this.decodeBehaviors(context, (UIComponent)editor);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        MarkdownEditor editor = (MarkdownEditor)component;
        editor.checkSecurity(context);
        this.encodeMarkup(context, editor);
        this.encodeScript(context, editor);
    }

    protected void encodeScript(FacesContext context, MarkdownEditor editor) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtMarkdownEditor", (UIComponent)editor).attr("minHeight", editor.getMinHeight(), "300px").attr("maxHeight", editor.getMaxHeight(), null).attr("mode", editor.getMode()).attr("toolbar", editor.getToolbar()).attr("placeholder", editor.getPlaceholder()).attr("direction", ComponentUtils.isRTL((FacesContext)context, (RTLAware)editor) ? "rtl" : "ltr", "ltr").attr("sideBySideFullscreen", editor.getSideBySideFullscreen(), true).attr("indentWithTabs", editor.getIndentWithTabs(), true).attr("lineNumbers", editor.getLineNumbers(), false).attr("promptURLs", editor.getPromptURLs(), false).attr("tabSize", editor.getTabSize(), 2).nativeAttr("extender", editor.getExtender());
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)editor);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, MarkdownEditor editor) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = editor.getClientId(context);
        writer.startElement("textarea", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("class", (Object)this.createStyleClass((UIInput)editor, "ui-inputfield ui-inputtextarea ui-widget ui-state-default"), "styleClass");
        writer.writeAttribute("style", (Object)"display:none", "style");
        this.renderAccessibilityAttributes(context, (UIInput)editor);
        this.renderRTLDirection(context, (UIComponent)editor);
        this.renderPassThruAttributes(context, (UIComponent)editor, HTML.TEXTAREA_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)editor, HTML.INPUT_TEXT_EVENTS);
        this.renderValidationMetadata(context, (EditableValueHolder)editor, new ClientValidator[0]);
        String valueToRender = ComponentUtils.getValueToRender((FacesContext)context, (UIComponent)editor);
        if (valueToRender != null) {
            writer.writeText((Object)valueToRender, "value");
        }
        writer.endElement("textarea");
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) {
        MarkdownEditor editor = (MarkdownEditor)component;
        String value = (String)submittedValue;
        Converter converter = ComponentUtils.getConverter((FacesContext)context, (UIComponent)component);
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)editor, value);
        }
        return value;
    }
}

