/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.remotecommand;

import jakarta.el.MethodExpression;
import jakarta.faces.view.facelets.ComponentConfig;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.CompositeFaceletHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.MetaRule;
import jakarta.faces.view.facelets.MetaRuleset;
import jakarta.faces.view.facelets.Metadata;
import jakarta.faces.view.facelets.MetadataTarget;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagAttributeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.primefaces.extensions.component.parameters.MethodSignatureTagHandler;
import org.primefaces.extensions.component.remotecommand.RemoteCommand;

public class RemoteCommandHandler
extends ComponentHandler {
    public RemoteCommandHandler(ComponentConfig config) {
        super(config);
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        MetaRuleset metaRuleset = super.createMetaRuleset(type);
        metaRuleset.addRule((MetaRule)new RemoteCommandMetaRule(this.getParameterTypes()));
        return metaRuleset;
    }

    private Class<?>[] getParameterTypes() {
        CompositeFaceletHandler handler;
        MethodSignatureTagHandler signatureTagHandler = null;
        if (this.nextHandler instanceof CompositeFaceletHandler && (handler = (CompositeFaceletHandler)this.nextHandler).getHandlers().length > 0 && handler.getHandlers()[0] instanceof MethodSignatureTagHandler) {
            signatureTagHandler = (MethodSignatureTagHandler)handler.getHandlers()[0];
        }
        if (signatureTagHandler == null) {
            return new Class[0];
        }
        return signatureTagHandler.getParameterTypes();
    }

    private static final class ActionListenerMetadata
    extends Metadata {
        private final TagAttribute attribute;
        private final Method method;
        private final Class<?>[] parameters;

        public ActionListenerMetadata(TagAttribute attribute, Method method, Class<?>[] parameters) {
            this.attribute = attribute;
            this.method = method;
            this.parameters = parameters;
        }

        public void applyMetadata(FaceletContext context, Object instance) {
            MethodExpression expression = this.attribute.getMethodExpression(context, null, (Class[])this.parameters);
            try {
                this.method.invoke(instance, expression);
            }
            catch (InvocationTargetException e) {
                throw new TagAttributeException(this.attribute, e.getCause());
            }
            catch (Exception e) {
                throw new TagAttributeException(this.attribute, (Throwable)e);
            }
        }
    }

    private static final class RemoteCommandMetaRule
    extends MetaRule {
        private final Class<?>[] parameters;

        public RemoteCommandMetaRule(Class<?>[] parameters) {
            this.parameters = parameters;
        }

        public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
            if (meta.isTargetInstanceOf(RemoteCommand.class) && RemoteCommand.PropertyKeys.actionListener.toString().equals(name)) {
                Method method = meta.getWriteMethod("actionListenerMethodExpression");
                return new ActionListenerMetadata(attribute, method, this.parameters);
            }
            return null;
        }
    }
}

