/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.validate;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.primefaces.extensions.component.inputphone.InputPhone;
import org.primefaces.extensions.util.MessageFactory;

public class PhoneValidator
implements Validator {
    private static final String MESSAGE_INVALID_KEY = "primefaces.extensions.inputphone.INVALID";

    public void validate(FacesContext context, UIComponent component, Object object) throws ValidatorException {
        InputPhone inputPhone = (InputPhone)component;
        String country = (String)context.getExternalContext().getRequestParameterMap().get(inputPhone.getClientId() + "_iso2");
        if (country == null || "auto".equals(country)) {
            country = "";
        }
        try {
            PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
            Phonenumber.PhoneNumber phoneNumber = phoneNumberUtil.parse((CharSequence)((String)object), country);
            if (!phoneNumberUtil.isValidNumber(phoneNumber)) {
                throw new ValidatorException(this.getMessage());
            }
        }
        catch (NumberParseException e) {
            throw new ValidatorException(this.getMessage());
        }
    }

    protected FacesMessage getMessage() {
        return MessageFactory.getMessage(MESSAGE_INVALID_KEY, FacesMessage.SEVERITY_ERROR, new Object[0]);
    }
}

