/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac;

import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import lombok.javac.CapturingDiagnosticListener;
import lombok.javac.JavacResolution;

public final class CompilerMessageSuppressor {
    private final Log log;
    private static final Field errWriterField;
    private static final Field warnWriterField;
    private static final Field noticeWriterField;
    private static final Field dumpOnErrorField;
    private static final Field promptOnErrorField;
    private static final Field diagnosticListenerField;
    private static final Field deferDiagnosticsField;
    private static final Field deferredDiagnosticsField;
    private static final Field diagnosticHandlerField;
    private static final ConcurrentMap<Class<?>, Field> handlerDeferredFields;
    private static final Field NULL_FIELD;
    private PrintWriter errWriter;
    private PrintWriter warnWriter;
    private PrintWriter noticeWriter;
    private Boolean dumpOnError;
    private Boolean promptOnError;
    private DiagnosticListener<?> contextDiagnosticListener;
    private DiagnosticListener<?> logDiagnosticListener;
    private final Context context;
    private static final boolean dontBother;
    private static final ThreadLocal<Queue<?>> queueCache;

    static Field getDeclaredField(Class<?> c, String fieldName) {
        try {
            Field field = c.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public CompilerMessageSuppressor(Context context) {
        this.log = Log.instance(context);
        this.context = context;
    }

    public boolean disableLoggers() {
        this.contextDiagnosticListener = this.context.get(DiagnosticListener.class);
        this.context.put(DiagnosticListener.class, (DiagnosticListener)null);
        if (dontBother) {
            return false;
        }
        boolean dontBotherInstance = false;
        PrintWriter dummyWriter = new PrintWriter(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        });
        if (deferDiagnosticsField != null) {
            try {
                if (Boolean.TRUE.equals(deferDiagnosticsField.get(this.log))) {
                    queueCache.set((Queue)deferredDiagnosticsField.get(this.log));
                    LinkedList empty = new LinkedList();
                    deferredDiagnosticsField.set(this.log, empty);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (diagnosticHandlerField != null) {
            try {
                Object handler = diagnosticHandlerField.get(this.log);
                Field field = CompilerMessageSuppressor.getDeferredField(handler);
                if (field != null) {
                    queueCache.set((Queue)field.get(handler));
                    LinkedList empty = new LinkedList();
                    field.set(handler, empty);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!dontBotherInstance) {
            try {
                this.errWriter = (PrintWriter)errWriterField.get(this.log);
                errWriterField.set(this.log, dummyWriter);
            }
            catch (Exception e) {
                dontBotherInstance = true;
            }
        }
        if (!dontBotherInstance) {
            try {
                this.warnWriter = (PrintWriter)warnWriterField.get(this.log);
                warnWriterField.set(this.log, dummyWriter);
            }
            catch (Exception e) {
                dontBotherInstance = true;
            }
        }
        if (!dontBotherInstance) {
            try {
                this.noticeWriter = (PrintWriter)noticeWriterField.get(this.log);
                noticeWriterField.set(this.log, dummyWriter);
            }
            catch (Exception e) {
                dontBotherInstance = true;
            }
        }
        if (!dontBotherInstance) {
            try {
                this.dumpOnError = (Boolean)dumpOnErrorField.get(this.log);
                dumpOnErrorField.set(this.log, false);
            }
            catch (Exception e) {
                dontBotherInstance = true;
            }
        }
        if (!dontBotherInstance) {
            try {
                this.promptOnError = (Boolean)promptOnErrorField.get(this.log);
                promptOnErrorField.set(this.log, false);
            }
            catch (Exception e) {
                dontBotherInstance = true;
            }
        }
        if (!dontBotherInstance) {
            try {
                this.logDiagnosticListener = (DiagnosticListener)diagnosticListenerField.get(this.log);
                diagnosticListenerField.set(this.log, null);
            }
            catch (Exception e) {
                dontBotherInstance = true;
            }
        }
        if (dontBotherInstance) {
            this.enableLoggers();
        }
        return !dontBotherInstance;
    }

    private static Field getDeferredField(Object handler) {
        Class<?> key = handler.getClass();
        Field field = (Field)handlerDeferredFields.get(key);
        if (field != null) {
            return field == NULL_FIELD ? null : field;
        }
        Field value = CompilerMessageSuppressor.getDeclaredField(key, "deferred");
        handlerDeferredFields.put(key, value == null ? NULL_FIELD : value);
        return CompilerMessageSuppressor.getDeferredField(handler);
    }

    public void enableLoggers() {
        if (this.contextDiagnosticListener != null) {
            this.context.put(DiagnosticListener.class, this.contextDiagnosticListener);
            this.contextDiagnosticListener = null;
        }
        if (this.errWriter != null) {
            try {
                errWriterField.set(this.log, this.errWriter);
                this.errWriter = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.warnWriter != null) {
            try {
                warnWriterField.set(this.log, this.warnWriter);
                this.warnWriter = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.noticeWriter != null) {
            try {
                noticeWriterField.set(this.log, this.noticeWriter);
                this.noticeWriter = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.dumpOnError != null) {
            try {
                dumpOnErrorField.set(this.log, this.dumpOnError);
                this.dumpOnError = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.promptOnError != null) {
            try {
                promptOnErrorField.set(this.log, this.promptOnError);
                this.promptOnError = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.logDiagnosticListener != null) {
            try {
                diagnosticListenerField.set(this.log, this.logDiagnosticListener);
                this.logDiagnosticListener = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (diagnosticHandlerField != null && queueCache.get() != null) {
            try {
                Object handler = diagnosticHandlerField.get(this.log);
                Field field = CompilerMessageSuppressor.getDeferredField(handler);
                if (field != null) {
                    field.set(handler, queueCache.get());
                    queueCache.set(null);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (deferDiagnosticsField != null && queueCache.get() != null) {
            try {
                deferredDiagnosticsField.set(this.log, queueCache.get());
                queueCache.set(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void removeAllBetween(JavaFileObject sourcefile, int startPos, int endPos) {
        DiagnosticListener listener = this.context.get(DiagnosticListener.class);
        if (listener instanceof CapturingDiagnosticListener) {
            ((CapturingDiagnosticListener)listener).suppress(startPos, endPos);
        }
        Field field = null;
        Object receiver = null;
        if (deferDiagnosticsField != null) {
            try {
                if (Boolean.TRUE.equals(deferDiagnosticsField.get(this.log))) {
                    field = deferredDiagnosticsField;
                    receiver = this.log;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (diagnosticHandlerField != null) {
            try {
                Object handler = diagnosticHandlerField.get(this.log);
                field = CompilerMessageSuppressor.getDeferredField(handler);
                receiver = handler;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (field == null || receiver == null) {
            return;
        }
        try {
            ListBuffer deferredDiagnostics = (ListBuffer)field.get(receiver);
            ListBuffer newDeferredDiagnostics = new ListBuffer();
            for (Object diag_ : deferredDiagnostics) {
                if (!(diag_ instanceof JCDiagnostic)) {
                    newDeferredDiagnostics.add(diag_);
                    continue;
                }
                JCDiagnostic diag = (JCDiagnostic)diag_;
                long here = diag.getStartPosition();
                if (here >= (long)startPos && here < (long)endPos && diag.getSource() == sourcefile) continue;
                newDeferredDiagnostics.add(diag);
            }
            field.set(receiver, newDeferredDiagnostics);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    static {
        handlerDeferredFields = new ConcurrentHashMap();
        queueCache = new ThreadLocal();
        errWriterField = CompilerMessageSuppressor.getDeclaredField(Log.class, "errWriter");
        warnWriterField = CompilerMessageSuppressor.getDeclaredField(Log.class, "warnWriter");
        noticeWriterField = CompilerMessageSuppressor.getDeclaredField(Log.class, "noticeWriter");
        dumpOnErrorField = CompilerMessageSuppressor.getDeclaredField(Log.class, "dumpOnError");
        promptOnErrorField = CompilerMessageSuppressor.getDeclaredField(Log.class, "promptOnError");
        diagnosticListenerField = CompilerMessageSuppressor.getDeclaredField(Log.class, "diagListener");
        dontBother = errWriterField == null || warnWriterField == null || noticeWriterField == null || dumpOnErrorField == null || promptOnErrorField == null || diagnosticListenerField == null;
        deferDiagnosticsField = CompilerMessageSuppressor.getDeclaredField(Log.class, "deferDiagnostics");
        deferredDiagnosticsField = CompilerMessageSuppressor.getDeclaredField(Log.class, "deferredDiagnostics");
        diagnosticHandlerField = CompilerMessageSuppressor.getDeclaredField(Log.class, "diagnosticHandler");
        NULL_FIELD = CompilerMessageSuppressor.getDeclaredField(JavacResolution.class, "NULL_FIELD");
    }
}

