/*
 * Decompiled with CFR 0.152.
 */
package lombok.patcher.equinox;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import lombok.patcher.ClassRootFinder;
import lombok.patcher.Hook;
import lombok.patcher.MethodTarget;
import lombok.patcher.ScriptManager;
import lombok.patcher.StackRequest;
import lombok.patcher.scripts.ScriptBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquinoxClassLoader
extends ClassLoader {
    private static final ConcurrentMap<ClassLoader, EquinoxClassLoader> hostLoaders = new ConcurrentHashMap<ClassLoader, EquinoxClassLoader>();
    private static final EquinoxClassLoader coreLoader = new EquinoxClassLoader();
    private static final Method resolveMethod;
    private static final List<String> prefixes;
    private static final List<String> corePrefixes;
    private final List<File> classpath = new ArrayList<File>();
    private final List<ClassLoader> subLoaders = new ArrayList<ClassLoader>();
    private final ConcurrentHashMap<String, String> cantFind = new ConcurrentHashMap();
    private static final String SELF_NAME = "lombok.patcher.equinox.EquinoxClassLoader";
    private final ConcurrentMap<String, WeakReference<Class<?>>> defineCache = new ConcurrentHashMap();

    private EquinoxClassLoader() {
        this.classpath.add(new File(ClassRootFinder.findClassRootOfClass(EquinoxClassLoader.class)));
    }

    public static void addPrefix(String ... additionalPrefixes) {
        prefixes.addAll(Arrays.asList(additionalPrefixes));
    }

    public static void addCorePrefix(String ... additionalPrefixes) {
        corePrefixes.addAll(Arrays.asList(additionalPrefixes));
    }

    public void addClasspath(String file) {
        this.classpath.add(new File(file));
    }

    public void addSubLoader(ClassLoader loader) {
        if (!this.subLoaders.contains(loader)) {
            this.subLoaders.add(loader);
        }
    }

    public static void registerScripts(ScriptManager manager) {
        manager.addScript(ScriptBuilder.exitEarly().target(new MethodTarget("org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader", "loadClass", "java.lang.Class", "java.lang.String", "boolean")).target(new MethodTarget("org.eclipse.osgi.framework.adapter.core.AbstractClassLoader", "loadClass", "java.lang.Class", "java.lang.String", "boolean")).target(new MethodTarget("org.eclipse.osgi.internal.loader.ModuleClassLoader", "loadClass", "java.lang.Class", "java.lang.String", "boolean")).decisionMethod(new Hook(SELF_NAME, "overrideLoadDecide", "boolean", "java.lang.ClassLoader", "java.lang.String", "boolean")).valueMethod(new Hook(SELF_NAME, "overrideLoadResult", "java.lang.Class", "java.lang.ClassLoader", "java.lang.String", "boolean")).request(StackRequest.THIS, StackRequest.PARAM1, StackRequest.PARAM2).build());
    }

    private void logLoadError(Throwable t) {
        t.printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        boolean controlLoad = false;
        EquinoxClassLoader resolver = resolve ? this : null;
        Class<?> alreadyLoaded = this.setCached(name, null, resolver);
        if (alreadyLoaded != null) {
            return alreadyLoaded;
        }
        for (String corePrefix : corePrefixes) {
            if (!name.startsWith(corePrefix)) continue;
            if (this != coreLoader) {
                return this.setCached(name, coreLoader.loadClass(name, resolve), resolver);
            }
            controlLoad = true;
            break;
        }
        for (String prefix : prefixes) {
            if (!name.startsWith(prefix)) continue;
            controlLoad = true;
            break;
        }
        for (File file : this.classpath) {
            if (file.isFile()) {
                Class<?> clazz;
                block26: {
                    ZipEntry entry;
                    JarFile jf;
                    block25: {
                        jf = new JarFile(file);
                        entry = jf.getEntry(name);
                        if (entry != null) break block25;
                        if (Collections.singletonList(jf).get(0) == null) continue;
                        jf.close();
                        continue;
                    }
                    try {
                        byte[] classData = EquinoxClassLoader.readStream(jf.getInputStream(entry));
                        clazz = this.setCached(name, this.defineClass(name, classData, 0, classData.length), resolver);
                        if (Collections.singletonList(jf).get(0) == null) break block26;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (Collections.singletonList(jf).get(0) != null) {
                                jf.close();
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            this.logLoadError(e);
                        }
                    }
                    jf.close();
                }
                return clazz;
                continue;
            }
            File target = new File(file, name);
            if (!target.exists()) continue;
            try {
                byte[] classData = EquinoxClassLoader.readStream(new FileInputStream(target));
                return this.setCached(name, this.defineClass(name, classData, 0, classData.length), resolver);
            }
            catch (IOException e) {
                this.logLoadError(e);
            }
        }
        if (controlLoad) {
            try {
                byte[] classData = EquinoxClassLoader.readStream(super.getResourceAsStream(name.replace(".", "/") + ".class"));
                return this.setCached(name, this.defineClass(name, classData, 0, classData.length), resolver);
            }
            catch (Exception ignore) {
            }
            catch (UnsupportedClassVersionError e) {
                System.err.println("BAD CLASS VERSION TRYING TO LOAD: " + name);
                throw e;
            }
        } else {
            try {
                return this.setCached(name, super.loadClass(name, resolve), resolver);
            }
            catch (ClassNotFoundException ignore) {
                // empty catch block
            }
        }
        this.cantFind.put(name, name);
        for (ClassLoader subLoader : this.subLoaders) {
            try {
                return this.setCached(name, subLoader.loadClass(name), resolve ? subLoader : null);
            }
            catch (ClassNotFoundException ignore) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    private static Class<?> resolveClass_(Class<?> c, ClassLoader resolver) {
        if (resolver == null || resolveMethod == null) {
            return c;
        }
        try {
            resolveMethod.invoke((Object)resolver, c);
        }
        catch (InvocationTargetException e) {
            throw EquinoxClassLoader.sneakyThrow(e);
        }
        catch (IllegalAccessException e) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return c;
    }

    public static RuntimeException sneakyThrow(Throwable t) {
        if (t == null) {
            throw new NullPointerException("t");
        }
        EquinoxClassLoader.sneakyThrow0(t);
        return null;
    }

    private static <T extends Throwable> void sneakyThrow0(Throwable t) throws T {
        throw t;
    }

    private Class<?> setCached(String name, Class<?> c, ClassLoader resolver) {
        if (c == null) {
            Class prev;
            WeakReference prevRef = (WeakReference)this.defineCache.get(name);
            Class clazz = prev = prevRef == null ? null : (Class)prevRef.get();
            if (prev == null) {
                return null;
            }
            return EquinoxClassLoader.resolveClass_(prev, resolver);
        }
        WeakReference<Class<?>> prevRef = this.defineCache.putIfAbsent(name, new WeakReference(c));
        if (prevRef == null) {
            return EquinoxClassLoader.resolveClass_(c, resolver);
        }
        Class prev = (Class)prevRef.get();
        if (prev != null) {
            return EquinoxClassLoader.resolveClass_(prev, resolver);
        }
        this.defineCache.remove(name, prevRef);
        return this.setCached(name, c, resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readStream(InputStream in) throws IOException {
        try {
            int r;
            byte[] b = new byte[4096];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((r = in.read(b)) != -1) {
                baos.write(b, 0, r);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            in.close();
        }
    }

    private static EquinoxClassLoader getHostLoader(ClassLoader original) {
        EquinoxClassLoader ecl = (EquinoxClassLoader)hostLoaders.get(original);
        if (ecl != null) {
            return ecl;
        }
        ecl = new EquinoxClassLoader();
        ecl.addSubLoader(original);
        hostLoaders.putIfAbsent(original, ecl);
        return (EquinoxClassLoader)hostLoaders.get(original);
    }

    public static boolean overrideLoadDecide(ClassLoader original, String name, boolean resolve) {
        EquinoxClassLoader hostLoader = EquinoxClassLoader.getHostLoader(original);
        if (hostLoader.cantFind.containsKey(name)) {
            return false;
        }
        for (String prefix : prefixes) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static Class<?> overrideLoadResult(ClassLoader original, String name, boolean resolve) throws ClassNotFoundException {
        EquinoxClassLoader hostLoader = EquinoxClassLoader.getHostLoader(original);
        hostLoader.addSubLoader(original);
        return hostLoader.loadClass(name, resolve);
    }

    static {
        prefixes = new ArrayList<String>();
        corePrefixes = new ArrayList<String>();
        corePrefixes.add("lombok.patcher.");
        Method m = null;
        try {
            m = ClassLoader.class.getDeclaredMethod("resolveClass", Class.class);
            m.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        resolveMethod = m;
    }
}

