/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.conduit;

import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.projectodd.stilts.conduit.spi.MessageConduitFactory;
import org.projectodd.stilts.conduit.spi.TransactionalMessageConduitFactory;
import org.projectodd.stilts.conduit.stomp.ConduitStompProvider;
import org.projectodd.stilts.conduit.xa.PseudoXAMessageConduitFactory;
import org.projectodd.stilts.stomp.server.StompServer;
import org.projectodd.stilts.stomp.spi.StompProvider;

public class ConduitServer<T extends MessageConduitFactory> {
    private static Logger log = Logger.getLogger(ConduitServer.class);
    private StompServer<ConduitStompProvider> server;
    private TransactionManager transactionManager;
    private T messageConduitFactory;
    private TransactionalMessageConduitFactory transactionalMessageConduitFactory;

    public ConduitServer() {
        this(8675);
    }

    public ConduitServer(int port) {
        this.server = new StompServer(port);
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setMessageConduitFactory(T messageConduitFactory) {
        this.messageConduitFactory = messageConduitFactory;
        if (messageConduitFactory instanceof TransactionalMessageConduitFactory) {
            this.transactionalMessageConduitFactory = (TransactionalMessageConduitFactory)messageConduitFactory;
        } else {
            log.errorf("WRAPPING WITH PSEUDO XA CONDUIT", new Object[0]);
            this.transactionalMessageConduitFactory = new PseudoXAMessageConduitFactory((MessageConduitFactory)messageConduitFactory);
        }
    }

    public T getMessageConduitFactory() {
        return this.messageConduitFactory;
    }

    public TransactionalMessageConduitFactory getTransactionalMessageConduitFactory() {
        return this.transactionalMessageConduitFactory;
    }

    public void start() throws Exception {
        log.errorf("CONDUIT_SERVER.start " + this.transactionManager, new Object[0]);
        this.transactionalMessageConduitFactory.setTransactionManager(this.transactionManager);
        ConduitStompProvider provider = new ConduitStompProvider(this.transactionManager, this.getTransactionalMessageConduitFactory());
        this.server.setStompProvider((StompProvider)provider);
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }
}

