/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.conduit.stomp;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.projectodd.stilts.conduit.spi.MessageConduit;
import org.projectodd.stilts.conduit.stomp.ConduitStompProvider;
import org.projectodd.stilts.conduit.stomp.ConduitStompTransaction;
import org.projectodd.stilts.stomp.Acknowledger;
import org.projectodd.stilts.stomp.Headers;
import org.projectodd.stilts.stomp.Heartbeat;
import org.projectodd.stilts.stomp.InvalidSubscriptionException;
import org.projectodd.stilts.stomp.InvalidTransactionException;
import org.projectodd.stilts.stomp.NotConnectedException;
import org.projectodd.stilts.stomp.StompException;
import org.projectodd.stilts.stomp.StompMessage;
import org.projectodd.stilts.stomp.Subscription;
import org.projectodd.stilts.stomp.protocol.StompFrame;
import org.projectodd.stilts.stomp.spi.StompConnection;
import org.projectodd.stilts.stomp.spi.StompSession;

public class ConduitStompConnection
implements StompConnection {
    private static Logger log = Logger.getLogger(ConduitStompConnection.class);
    private Map<String, Subscription> subscriptions = new HashMap<String, Subscription>();
    private Map<String, ConduitStompTransaction> namedTransactions = new HashMap<String, ConduitStompTransaction>();
    private MessageConduit messageConduit;
    private ConduitStompProvider stompProvider;
    private StompFrame.Version version;
    private Heartbeat heartbeat;

    public ConduitStompConnection(ConduitStompProvider stompProvider, MessageConduit messageConduit, StompFrame.Version version, Heartbeat hb) throws StompException {
        log.debugf("New connection: %s", (Object)messageConduit);
        this.stompProvider = stompProvider;
        this.messageConduit = messageConduit;
        this.version = version;
        this.heartbeat = hb;
    }

    public Heartbeat getHeartbeat() {
        return this.heartbeat;
    }

    public StompSession getSession() {
        return this.messageConduit.getSession();
    }

    public StompFrame.Version getVersion() {
        return this.version;
    }

    public ConduitStompProvider getStompProvider() {
        return this.stompProvider;
    }

    public MessageConduit getMessageConduit() {
        return this.messageConduit;
    }

    public void send(StompMessage message, String transactionId) throws StompException {
        if (transactionId != null) {
            this.getTransaction(transactionId).send(message);
        } else {
            this.send(message);
        }
    }

    protected void send(StompMessage message) throws StompException {
        try {
            this.messageConduit.send(message);
        }
        catch (Exception e) {
            log.errorf((Throwable)e, "Cannot send message: %s", (Object)message);
            throw new StompException((Throwable)e);
        }
    }

    void ack(Acknowledger acknowledger, String transactionId) throws StompException {
        if (transactionId != null) {
            this.getTransaction(transactionId).ack(acknowledger);
        } else {
            try {
                acknowledger.ack();
            }
            catch (Exception e) {
                throw new StompException((Throwable)e);
            }
        }
    }

    void nack(Acknowledger acknowledger, String transactionId) throws StompException {
        if (transactionId != null) {
            this.getTransaction(transactionId).nack(acknowledger);
        } else {
            try {
                acknowledger.nack();
            }
            catch (Exception e) {
                throw new StompException((Throwable)e);
            }
        }
    }

    synchronized ConduitStompTransaction getTransaction(String transactionId) throws InvalidTransactionException {
        ConduitStompTransaction transaction = this.namedTransactions.get(transactionId);
        if (transaction == null) {
            throw new InvalidTransactionException(transactionId);
        }
        return transaction;
    }

    synchronized ConduitStompTransaction removeTransaction(String transactionId) {
        return this.namedTransactions.remove(transactionId);
    }

    public synchronized void begin(String transactionId, Headers headers) throws StompException {
        Transaction jtaTransaction = null;
        TransactionManager tm = this.getStompProvider().getTransactionManager();
        try {
            tm.begin();
            jtaTransaction = tm.getTransaction();
            tm.suspend();
        }
        catch (NotSupportedException e) {
            throw new StompException((Throwable)e);
        }
        catch (SystemException e) {
            throw new StompException((Throwable)e);
        }
        try {
            ConduitStompTransaction transaction = this.createTransaction(jtaTransaction, transactionId);
            this.namedTransactions.put(transactionId, transaction);
        }
        catch (Exception e) {
            throw new StompException((Throwable)e);
        }
    }

    public synchronized void commit(String transactionId) throws StompException {
        ConduitStompTransaction transaction = this.removeTransaction(transactionId);
        if (transaction == null) {
            throw new InvalidTransactionException(transactionId);
        }
        transaction.commit();
    }

    public synchronized void abort(String transactionId) throws StompException {
        ConduitStompTransaction transaction = this.removeTransaction(transactionId);
        if (transaction == null) {
            throw new InvalidTransactionException(transactionId);
        }
        transaction.abort();
    }

    public synchronized Subscription subscribe(String destination, String subscriptionId, Headers headers) throws StompException {
        try {
            Subscription subscription = this.createSubscription(destination, subscriptionId, headers);
            if (subscription == null) {
                return null;
            }
            this.subscriptions.put(subscription.getId(), subscription);
            return subscription;
        }
        catch (Exception e) {
            throw new StompException((Throwable)e);
        }
    }

    public Subscription createSubscription(String destination, String subscriptionId, Headers headers) throws Exception {
        return this.messageConduit.subscribe(subscriptionId, destination, headers);
    }

    public synchronized void unsubscribe(String id, Headers headers) throws StompException {
        Subscription subscription = this.subscriptions.remove(id);
        if (subscription == null) {
            throw new InvalidSubscriptionException(id);
        }
        subscription.cancel();
    }

    public synchronized void disconnect() throws NotConnectedException {
        for (ConduitStompTransaction conduitStompTransaction : this.namedTransactions.values()) {
            try {
                conduitStompTransaction.abort();
            }
            catch (StompException e) {
                log.errorf((Throwable)e, "Cannot disconnect", new Object[0]);
            }
        }
        this.namedTransactions.clear();
        for (Subscription subscription : this.subscriptions.values()) {
            try {
                subscription.cancel();
            }
            catch (StompException e) {
                log.errorf((Throwable)e, "Cannot cancel subsrciption: %s", (Object)subscription);
            }
        }
        this.subscriptions.clear();
        this.stompProvider.unregister(this);
    }

    protected ConduitStompTransaction createTransaction(Transaction jtaTransaction, String transactionId) throws Exception {
        return new ConduitStompTransaction(this, jtaTransaction, transactionId);
    }
}

