/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.conduit.xa;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.logging.Logger;
import org.projectodd.stilts.conduit.spi.MessageConduit;
import org.projectodd.stilts.stomp.Acknowledger;
import org.projectodd.stilts.stomp.StompMessage;

class PseudoXATransaction {
    private static Logger log = Logger.getLogger(PseudoXATransaction.class);
    private boolean rollbackOnly;
    private ConcurrentLinkedQueue<StompMessage> sentMessages = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Acknowledger> acks = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Acknowledger> nacks = new ConcurrentLinkedQueue();

    PseudoXATransaction() {
    }

    void setRollbackOnly(boolean rollbackOnly) {
        this.rollbackOnly = rollbackOnly;
    }

    boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    boolean isReadOnly() {
        return this.sentMessages.isEmpty() && this.acks.isEmpty() && this.nacks.isEmpty();
    }

    void addSentMessage(StompMessage message) {
        this.sentMessages.add(message);
    }

    boolean hasSentMessages() {
        return !this.sentMessages.isEmpty();
    }

    void addAck(Acknowledger acknowledger) {
        this.acks.add(acknowledger);
    }

    boolean hasAcks() {
        return !this.acks.isEmpty();
    }

    void addNack(Acknowledger acknowledger) {
        this.nacks.add(acknowledger);
    }

    boolean hasNacks() {
        return !this.nacks.isEmpty();
    }

    public void commit(MessageConduit conduit) {
        for (StompMessage stompMessage : this.sentMessages) {
            try {
                conduit.send(stompMessage);
            }
            catch (Exception e) {
                log.errorf((Throwable)e, "Cannot send message: %s", (Object)stompMessage);
            }
        }
        this.sentMessages.clear();
        for (Acknowledger acknowledger : this.acks) {
            try {
                acknowledger.ack();
            }
            catch (Exception e) {
                log.errorf((Throwable)e, "Cannot ack: %s", (Object)acknowledger);
            }
        }
        this.acks.clear();
        for (Acknowledger acknowledger : this.nacks) {
            try {
                acknowledger.nack();
            }
            catch (Exception e) {
                log.errorf((Throwable)e, "Cannot nack: %s", (Object)acknowledger);
            }
        }
        this.nacks.clear();
    }

    public void rollback(MessageConduit messageConduit) {
        this.sentMessages.clear();
        this.acks.clear();
    }
}

