/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.server.protocol;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jboss.logging.Logger;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.projectodd.stilts.stomp.Headers;
import org.projectodd.stilts.stomp.Heartbeat;
import org.projectodd.stilts.stomp.StompException;
import org.projectodd.stilts.stomp.protocol.StompFrame;
import org.projectodd.stilts.stomp.protocol.StompFrames;
import org.projectodd.stilts.stomp.server.protocol.AbstractControlFrameHandler;
import org.projectodd.stilts.stomp.server.protocol.ChannelMessageSink;
import org.projectodd.stilts.stomp.server.protocol.ConnectionContext;
import org.projectodd.stilts.stomp.server.protocol.HostDecodedEvent;
import org.projectodd.stilts.stomp.server.protocol.HostMismatchException;
import org.projectodd.stilts.stomp.server.websockets.protocol.SessionDecodedEvent;
import org.projectodd.stilts.stomp.spi.StompConnection;
import org.projectodd.stilts.stomp.spi.StompProvider;
import org.projectodd.stilts.stomp.spi.TransactionalAcknowledgeableMessageSink;

public class ConnectHandler
extends AbstractControlFrameHandler {
    private static Logger log = Logger.getLogger(ConnectHandler.class);
    private static final Pattern HEART_BEAT_PATTERN = Pattern.compile("^\\d+,\\d+$");
    private static final Pattern VERSION_PATTERN = Pattern.compile("^([^\\s]+,)*[^\\s]*$");
    private String host;
    private String sessionId;

    public ConnectHandler(StompProvider server, ConnectionContext context) {
        super(server, context, StompFrame.Command.CONNECT);
        this.setRequiresClientIdentification(false);
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof HostDecodedEvent) {
            this.host = ((HostDecodedEvent)e).getHost();
        } else if (e instanceof SessionDecodedEvent) {
            this.sessionId = ((SessionDecodedEvent)e).getSessionId();
        } else {
            super.handleUpstream(ctx, e);
        }
    }

    @Override
    public void handleControlFrame(ChannelHandlerContext channelContext, StompFrame frame) {
        try {
            StompFrame.Version version = this.checkVersion(frame);
            Heartbeat hb = this.checkHeartbeat(frame, version);
            Headers headers = frame.getHeaders();
            String hostHeader = headers.get("host");
            if (hostHeader == null) {
                if (this.host != null) {
                    headers.put("host", this.host);
                }
            } else if (this.host != null && !hostHeader.equals(this.host)) {
                throw new HostMismatchException(this.host, hostHeader);
            }
            headers.remove("session");
            if (this.sessionId != null) {
                headers.put("session", this.sessionId);
            }
            this.checkHost(headers, version);
            StompConnection stompConnection = this.getStompProvider().createConnection((TransactionalAcknowledgeableMessageSink)new ChannelMessageSink(channelContext.getChannel(), this.getContext().getAckManager()), headers, version, hb);
            if (stompConnection != null) {
                this.getContext().setStompConnection(stompConnection);
                StompFrame connected = StompFrames.newConnectedFrame((String)stompConnection.getSession().getId(), (StompFrame.Version)version);
                if (hb != null) {
                    connected.setHeader("heart-beat", hb.getServerSend() + "," + hb.getServerReceive());
                }
                this.sendFrame(channelContext, connected);
            }
        }
        catch (StompException e) {
            log.error((Object)"Error connecting", (Throwable)e);
            this.sendErrorAndClose(channelContext, e.getMessage(), frame);
        }
    }

    private Heartbeat checkHeartbeat(StompFrame frame, StompFrame.Version version) throws StompException {
        Heartbeat hb = null;
        String heartBeat = frame.getHeader("heart-beat");
        if (StringUtils.isNotBlank((String)heartBeat) && !version.isBefore(StompFrame.Version.VERSION_1_1)) {
            if (!HEART_BEAT_PATTERN.matcher(heartBeat).matches()) {
                throw new StompException("Heartbeat must be specified in msec as two comma-separated values.");
            }
            String[] components = heartBeat.split(",");
            try {
                hb = new Heartbeat();
                hb.setClientReceive(Integer.parseInt(components[0]));
                hb.setClientSend(Integer.parseInt(components[1]));
            }
            catch (Exception ex) {
                throw new StompException("Heartbeat values must be integers.");
            }
        }
        return hb;
    }

    private String checkHost(Headers headers, StompFrame.Version version) throws StompException {
        String host = headers.get("host");
        if (StringUtils.isBlank((String)host) && version.isAfter(StompFrame.Version.VERSION_1_0)) {
            throw new StompException("Must specify host in STOMP protocol 1.1 and above.");
        }
        return host;
    }

    private StompFrame.Version checkVersion(StompFrame frame) throws StompException {
        String acceptVersion = frame.getHeader("accept-version");
        if (acceptVersion == null) {
            return StompFrame.Version.VERSION_1_0;
        }
        if (!VERSION_PATTERN.matcher(acceptVersion).matches()) {
            throw new StompException("Accept-version header value must be an incrementing comma-separated list.");
        }
        String[] versions = acceptVersion.split(",");
        StompFrame.Version selectedVersion = null;
        for (int i = versions.length - 1; i >= 0 && (selectedVersion = StompFrame.Version.forVersionString((String)versions[i])) == null; --i) {
        }
        if (selectedVersion == null) {
            throw new StompException("Supported protocol versions are " + StompFrame.Version.supportedVersions());
        }
        return selectedVersion;
    }
}

