/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.server.protocol;

import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.projectodd.stilts.stomp.NotConnectedException;
import org.projectodd.stilts.stomp.protocol.StompFrame;
import org.projectodd.stilts.stomp.protocol.StompFrames;
import org.projectodd.stilts.stomp.server.protocol.AbstractControlFrameHandler;
import org.projectodd.stilts.stomp.server.protocol.ConnectionContext;
import org.projectodd.stilts.stomp.spi.StompProvider;

public class DisconnectHandler
extends AbstractControlFrameHandler {
    public DisconnectHandler(StompProvider server, ConnectionContext context) {
        super(server, context, StompFrame.Command.DISCONNECT);
    }

    @Override
    public void handleControlFrame(ChannelHandlerContext channelContext, StompFrame frame) {
        try {
            this.getStompConnection().disconnect();
        }
        catch (NotConnectedException e) {
            // empty catch block
        }
        this.getContext().setActive(false);
        String receiptId = frame.getHeader("receipt");
        if (receiptId != null) {
            ChannelFuture future = channelContext.getChannel().write((Object)StompFrames.newReceiptFrame((String)receiptId));
            future.addListener(ChannelFutureListener.CLOSE);
        } else {
            channelContext.getChannel().close();
        }
    }
}

