/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.server.protocol;

import org.apache.commons.lang.StringUtils;
import org.jboss.logging.Logger;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.projectodd.stilts.stomp.StompException;
import org.projectodd.stilts.stomp.protocol.StompFrame;
import org.projectodd.stilts.stomp.server.protocol.AbstractControlFrameHandler;
import org.projectodd.stilts.stomp.server.protocol.ConnectionContext;
import org.projectodd.stilts.stomp.spi.StompProvider;

public class SubscribeHandler
extends AbstractControlFrameHandler {
    private static Logger log = Logger.getLogger(SubscribeHandler.class);

    public SubscribeHandler(StompProvider server, ConnectionContext context) {
        super(server, context, StompFrame.Command.SUBSCRIBE);
    }

    @Override
    public void handleControlFrame(ChannelHandlerContext channelContext, StompFrame frame) {
        String id = null;
        String destination = null;
        try {
            destination = frame.getHeader("destination");
            if (StringUtils.isEmpty((String)destination)) {
                throw new StompException("Cannot subscribe without destination.");
            }
            id = frame.getHeader("id");
            if (StringUtils.isEmpty((String)id)) {
                throw new StompException("Cannot subscribe without ID.");
            }
            this.getStompConnection().subscribe(destination, id, frame.getHeaders());
        }
        catch (StompException e) {
            log.error((Object)("Error performing subscription to '" + destination + "' for id '" + id + "'"), (Throwable)e);
            this.sendError(channelContext, e.getMessage(), frame);
        }
    }
}

