/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomplet.container;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.projectodd.stilts.stomp.Acknowledger;
import org.projectodd.stilts.stomplet.container.AckSet;

public class IndividualAckSet
implements AckSet {
    private Map<String, Acknowledger> acknowledgers = new ConcurrentHashMap<String, Acknowledger>();

    @Override
    public void ack(String messageId) throws Exception {
        Acknowledger ack = this.acknowledgers.remove(messageId);
        if (ack != null) {
            ack.ack();
        }
    }

    @Override
    public void nack(String messageId) throws Exception {
        Acknowledger ack = this.acknowledgers.remove(messageId);
        if (ack != null) {
            ack.nack();
        }
    }

    @Override
    public void addAcknowledger(String messageId, Acknowledger acknowledger) {
        this.acknowledgers.put(messageId, acknowledger);
    }

    @Override
    public void close() {
        for (Acknowledger each : this.acknowledgers.values()) {
            try {
                each.nack();
            }
            catch (Exception exception) {}
        }
    }
}

