/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomplet.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.projectodd.stilts.stomplet.Stomplet;
import org.projectodd.stilts.stomplet.container.StompletActivator;

public class Route {
    private static final Pattern SEGMENT_PATTERN = Pattern.compile(":([a-zA-Z0-9_\\-]+)");
    private String pattern;
    private Stomplet stomplet;
    private Pattern regexp;
    private String[] segmentNames;

    public Route(String pattern, Stomplet stomplet) {
        this.pattern = pattern;
        this.stomplet = stomplet;
        this.setUpRegexp();
    }

    protected void setUpRegexp() {
        Matcher segmentMatcher = SEGMENT_PATTERN.matcher(this.pattern);
        StringBuilder newPattern = new StringBuilder();
        ArrayList<String> segmentNames = new ArrayList<String>();
        int end = 0;
        while (segmentMatcher.find()) {
            newPattern.append(this.pattern.substring(end, segmentMatcher.start()));
            newPattern.append("([^\\/]+)");
            end = segmentMatcher.end();
            String segmentName = segmentMatcher.group(1);
            segmentNames.add(segmentName);
        }
        newPattern.append(this.pattern.substring(end));
        this.regexp = Pattern.compile(newPattern.toString());
        this.segmentNames = segmentNames.toArray(new String[segmentNames.size()]);
    }

    public StompletActivator match(String destination) {
        Matcher routeMatcher = this.regexp.matcher(destination);
        if (routeMatcher.matches()) {
            HashMap<String, String> matches = new HashMap<String, String>();
            for (int i = 0; i < this.segmentNames.length; ++i) {
                matches.put(this.segmentNames[i], routeMatcher.group(i + 1));
            }
            return new StompletActivator(this, destination, matches);
        }
        return null;
    }

    public String getPatternString() {
        return this.pattern;
    }

    public Stomplet getStomplet() {
        return this.stomplet;
    }

    public String toString() {
        return "[Route: pattern=" + this.pattern + "; stomplet=" + this.stomplet + "]";
    }
}

