/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomplet.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.projectodd.stilts.stomp.InvalidDestinationException;
import org.projectodd.stilts.stomp.StompException;
import org.projectodd.stilts.stomp.StompMessage;
import org.projectodd.stilts.stomp.spi.StompSession;
import org.projectodd.stilts.stomplet.MessageRouter;
import org.projectodd.stilts.stomplet.Stomplet;
import org.projectodd.stilts.stomplet.StompletConfig;
import org.projectodd.stilts.stomplet.XAStomplet;
import org.projectodd.stilts.stomplet.container.DefaultStompletConfig;
import org.projectodd.stilts.stomplet.container.DefaultStompletContext;
import org.projectodd.stilts.stomplet.container.Route;
import org.projectodd.stilts.stomplet.container.StompletActivator;
import org.projectodd.stilts.stomplet.container.StompletContainer;
import org.projectodd.stilts.stomplet.container.xa.PseudoXAStomplet;

public class SimpleStompletContainer
implements StompletContainer,
MessageRouter {
    private DefaultStompletContext stompletContext;
    private final List<Route> routes = new ArrayList<Route>();

    @Override
    public void start() throws Exception {
        this.stompletContext = new DefaultStompletContext(this);
    }

    @Override
    public void stop() throws Exception {
        while (!this.routes.isEmpty()) {
            Route route = this.routes.remove(0);
            this.destroy(route.getStomplet());
        }
    }

    protected void destroy(Stomplet stomplet) throws StompException {
        stomplet.destroy();
    }

    public void addStomplet(String destinationPattern, Stomplet stomplet) throws StompException {
        this.addStomplet(destinationPattern, stomplet, new HashMap<String, String>());
    }

    public void addStomplet(String destinationPattern, Stomplet stomplet, Map<String, String> properties) throws StompException {
        DefaultStompletConfig config = new DefaultStompletConfig(this.stompletContext, properties);
        Object xaStomplet = null;
        xaStomplet = stomplet instanceof XAStomplet ? (XAStomplet)stomplet : new PseudoXAStomplet(stomplet);
        xaStomplet.initialize((StompletConfig)config);
        Route route = new Route(destinationPattern, (Stomplet)xaStomplet);
        this.routes.add(route);
    }

    public void removeStomplet(String destinationPattern) throws StompException {
        Iterator<Route> iterator = this.routes.iterator();
        while (iterator.hasNext()) {
            Route route = iterator.next();
            if (!route.getPatternString().equals(destinationPattern)) continue;
            route.getStomplet().destroy();
            iterator.remove();
            break;
        }
    }

    public void send(StompMessage message, StompSession session) throws StompException {
        StompletActivator activator = this.getActivator(message.getDestination());
        if (activator == null) {
            throw new InvalidDestinationException(message.getDestination());
        }
        activator.send(message, session);
    }

    @Override
    public StompletActivator getActivator(String destination) {
        Route route;
        StompletActivator activator = null;
        Iterator<Route> i$ = this.routes.iterator();
        while (i$.hasNext() && (activator = (route = i$.next()).match(destination)) == null) {
        }
        return activator;
    }
}

