/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomplet.container;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.XAResource;
import org.projectodd.stilts.stomp.Headers;
import org.projectodd.stilts.stomp.StompException;
import org.projectodd.stilts.stomp.StompMessage;
import org.projectodd.stilts.stomp.Subscription;
import org.projectodd.stilts.stomp.spi.StompSession;
import org.projectodd.stilts.stomplet.Stomplet;
import org.projectodd.stilts.stomplet.Subscriber;
import org.projectodd.stilts.stomplet.XAStomplet;
import org.projectodd.stilts.stomplet.container.Route;
import org.projectodd.stilts.stomplet.container.StompletMessageConduit;
import org.projectodd.stilts.stomplet.container.SubscriberImpl;
import org.projectodd.stilts.stomplet.container.SubscriptionImpl;

public class StompletActivator {
    protected Route route;
    protected String destination;
    protected Map<String, String> matches;

    public StompletActivator(Route route, String destination, Map<String, String> matches) {
        this.route = route;
        this.destination = destination;
        this.matches = matches;
    }

    public Route getRoute() {
        return this.route;
    }

    public String getDestination() {
        return this.destination;
    }

    public void put(String name, String value) {
        this.matches.put(name, value);
    }

    public String get(String name) {
        return this.matches.get(name);
    }

    public Map<String, String> getMatches() {
        return this.matches;
    }

    public Set<XAResource> getXAResources() {
        Stomplet stomplet = this.getRoute().getStomplet();
        if (stomplet instanceof XAStomplet) {
            return ((XAStomplet)stomplet).getXAResources();
        }
        return Collections.emptySet();
    }

    public void send(StompMessage message, StompSession session) throws StompException {
        this.route.getStomplet().onMessage(message, session);
    }

    public Subscription subscribe(StompletMessageConduit messageConduit, String subscriptionId, String destination, Headers headers) throws StompException {
        Stomplet stomplet = this.getRoute().getStomplet();
        Subscription.AckMode ackMode = Subscription.AckMode.getAckMode((String)headers.get("ack"));
        SubscriberImpl subscriber = new SubscriberImpl(messageConduit.getSession(), stomplet, subscriptionId, destination, messageConduit.getMessageSink(), ackMode);
        stomplet.onSubscribe((Subscriber)subscriber);
        SubscriptionImpl subscription = new SubscriptionImpl(stomplet, subscriber);
        return subscription;
    }
}

